/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.ddi.index;

import fr.insee.ddi.exception.DuplicateIdException;
import fr.insee.ddi.exception.IndexingException;
import fr.insee.ddi.lifecycle33.instance.DDIInstanceDocument;
import fr.insee.ddi.lifecycle33.reusable.AbstractIdentifiableType;
import fr.insee.ddi.utils.DDIUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.TypeDescriptor;

public class DDIIndex {
    private static final Logger log = LogManager.getLogger();
    private Map<String, AbstractIdentifiableType> index;
    private Map<String, String> parentsMap;

    private void setup() {
        this.index = new HashMap<String, AbstractIdentifiableType>();
        this.parentsMap = new HashMap<String, String>();
    }

    public void indexDDI(DDIInstanceDocument ddiInstanceDocument) throws DuplicateIdException {
        this.indexDDIObject(ddiInstanceDocument.getDDIInstance());
    }

    public void indexDDIObject(AbstractIdentifiableType ddiObject) throws DuplicateIdException {
        log.info("Indexing DDI object {}...", (Object)DDIUtils.ddiToString(ddiObject));
        this.setup();
        this.recursiveIndexing(ddiObject);
        log.info("Finished indexing of DDI object.");
    }

    private void recursiveIndexing(AbstractIdentifiableType ddiObject) throws IndexingException, DuplicateIdException {
        String ddiObjectId;
        String string = ddiObjectId = !ddiObject.getIDList().isEmpty() ? ddiObject.getIDArray(0).getStringValue() : null;
        if (ddiObjectId == null) {
            throw new IndexingException("DDI object with null identifier encountered while indexing.");
        }
        this.index.merge(ddiObjectId, ddiObject, (oldDDIObject, newDDIObject) -> {
            throw new DuplicateIdException(String.format("Duplicate ID \"%s\" found in given DDI.", ddiObjectId));
        });
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)ddiObject);
        Iterator iterator = Arrays.stream(beanWrapper.getPropertyDescriptors()).filter(propertyDescriptor -> !propertyDescriptor.getName().equals("class")).iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)iterator.next();
            if (!List.class.isAssignableFrom(propertyDescriptor2.getPropertyType())) continue;
            TypeDescriptor typeDescriptor = beanWrapper.getPropertyTypeDescriptor(propertyDescriptor2.getName());
            assert (typeDescriptor != null);
            Class listContentType = typeDescriptor.getResolvableType().getGeneric(new int[]{0}).getRawClass();
            assert (listContentType != null || propertyDescriptor2.getName().equals("listValue") || propertyDescriptor2.getName().equals("limitArrayIndex"));
            if (listContentType == null || !AbstractIdentifiableType.class.isAssignableFrom(listContentType)) continue;
            this.indexListContent(ddiObject, ddiObjectId, propertyDescriptor2);
        }
    }

    private void indexListContent(AbstractIdentifiableType ddiObject, String ddiObjectId, PropertyDescriptor propertyDescriptor) {
        try {
            Collection ddiCollection = (Collection)propertyDescriptor.getReadMethod().invoke((Object)ddiObject, new Object[0]);
            for (AbstractIdentifiableType ddiObject2 : ddiCollection) {
                this.parentsMap.put(ddiObject2.getIDArray(0).getStringValue(), ddiObjectId);
                this.recursiveIndexing(ddiObject2);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IndexingException(String.format("Error when calling read method from property descriptor '%s' in class %s.", propertyDescriptor.getName(), ddiObject.getClass()), e);
        }
    }

    public Map<String, AbstractIdentifiableType> getIndex() {
        return this.index;
    }

    public AbstractIdentifiableType get(String ddiObjectId) {
        AbstractIdentifiableType object = this.index.get(ddiObjectId);
        if (object == null) {
            throw new NoSuchElementException(String.format("Index has no object with id '%s'.", ddiObjectId));
        }
        return object;
    }

    public <T extends AbstractIdentifiableType> T get(String ddiObjectId, Class<T> clazz) {
        AbstractIdentifiableType object = this.get(ddiObjectId);
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(String.format("Index object with id '%s' is of type %s that cannot be cast to %s.", ddiObjectId, ddiObjectId.getClass(), clazz));
        }
        return (T)((AbstractIdentifiableType)clazz.cast(object));
    }

    public boolean containsId(String ddiObjectId) {
        return this.index.containsKey(ddiObjectId);
    }

    public AbstractIdentifiableType getParent(String ddiObjectId) {
        return this.get(this.parentsMap.get(ddiObjectId));
    }

    public <T extends AbstractIdentifiableType> T getParent(String ddiObjectId, Class<T> clazz) {
        return this.get(this.parentsMap.get(ddiObjectId), clazz);
    }
}

