/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.ddi.utils;

import fr.insee.ddi.lifecycle33.reusable.AbstractIdentifiableType;
import fr.insee.ddi.lifecycle33.reusable.IDType;

public class DDIUtils {
    private DDIUtils() {
    }

    public static String ddiToString(Object ddiObject) {
        String className = ddiObject.getClass().getSimpleName();
        if (!(ddiObject instanceof AbstractIdentifiableType)) {
            return className;
        }
        AbstractIdentifiableType ddiIdentifiableObject = (AbstractIdentifiableType)ddiObject;
        if (ddiIdentifiableObject.getIDList().isEmpty()) {
            return className + "[id=null]";
        }
        return className + "[id=" + ddiIdentifiableObject.getIDArray(0).getStringValue() + "]";
    }

    public static String getIdValue(AbstractIdentifiableType ddiIdentifiableObject) {
        if (ddiIdentifiableObject.getIDList().isEmpty()) {
            return null;
        }
        return ddiIdentifiableObject.getIDArray(0).getStringValue();
    }

    public static void setIdValue(AbstractIdentifiableType ddiIdentifiableObject, String id) {
        if (ddiIdentifiableObject.getIDList().isEmpty()) {
            ddiIdentifiableObject.getIDList().add((IDType)IDType.Factory.newInstance());
        }
        ddiIdentifiableObject.getIDArray(0).setStringValue(id);
    }
}

