/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import fr.insee.lunatic.model.flat.CleanedVariableEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleaningVariableEntry {
    private static final Logger log = LoggerFactory.getLogger(CleaningVariableEntry.class);
    private String cleaningVariableName;
    @JsonValue
    private final Map<String, String> cleanedVariables;

    public CleaningVariableEntry(String cleaningVariableName) {
        this.cleaningVariableName = cleaningVariableName;
        this.cleanedVariables = new LinkedHashMap<String, String>();
    }

    @JsonCreator
    private CleaningVariableEntry(Map<String, String> cleanedVariables) {
        this.cleanedVariables = cleanedVariables;
    }

    public void addCleanedVariable(CleanedVariableEntry cleanedVariableEntry) {
        if (this.cleanedVariables.containsKey(cleanedVariableEntry.variableName())) {
            log.warn("Overwriting cleaned variable entry '{}' in cleaning variable entry '{}'", (Object)cleanedVariableEntry.variableName(), (Object)this.cleaningVariableName);
        }
        this.cleanedVariables.put(cleanedVariableEntry.variableName(), cleanedVariableEntry.filterExpression());
    }

    public CleanedVariableEntry getCleanedVariable(String cleanedVariableName) {
        return new CleanedVariableEntry(cleanedVariableName, this.cleanedVariables.get(cleanedVariableName));
    }

    public Set<String> getCleanedVariableNames() {
        return this.cleanedVariables.keySet();
    }

    public int countCleanedVariables() {
        return this.cleanedVariables.size();
    }

    public CleanedVariableEntry removeCleanedVariable(String cleanedVariableName) {
        return new CleanedVariableEntry(cleanedVariableName, this.cleanedVariables.remove(cleanedVariableName));
    }

    public String getCleaningVariableName() {
        return this.cleaningVariableName;
    }
}

