/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import fr.insee.lunatic.model.flat.ComponentType;
import fr.insee.lunatic.model.flat.ComponentTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Question
extends ComponentType {
    private final List<ComponentType> components;

    public Question() {
        this.componentType = ComponentTypeEnum.QUESTION;
        this.components = new ArrayList<ComponentType>();
    }

    public void addComponent(ComponentType component) {
        if (!Question.isQuestionComponent(component)) {
            throw new IllegalArgumentException("Component of type " + String.valueOf((Object)component.getComponentType()) + " cannot be inserted in a Question component.");
        }
        this.components.add(component);
    }

    public void addComponents(Collection<ComponentType> components) {
        components.forEach(this::addComponent);
    }

    public static boolean isQuestionComponent(ComponentType component) {
        if (component.getComponentType() == null) {
            return false;
        }
        return switch (component.getComponentType()) {
            default -> throw new MatchException(null, null);
            case ComponentTypeEnum.CHECKBOX_BOOLEAN, ComponentTypeEnum.INPUT, ComponentTypeEnum.TEXTAREA, ComponentTypeEnum.INPUT_NUMBER, ComponentTypeEnum.DATEPICKER, ComponentTypeEnum.DURATION, ComponentTypeEnum.CHECKBOX_ONE, ComponentTypeEnum.RADIO, ComponentTypeEnum.DROPDOWN, ComponentTypeEnum.SUGGESTER, ComponentTypeEnum.TEXT, ComponentTypeEnum.CHECKBOX_GROUP, ComponentTypeEnum.TABLE, ComponentTypeEnum.ROSTER_FOR_LOOP, ComponentTypeEnum.PAIRWISE_LINKS -> true;
            case ComponentTypeEnum.QUESTIONNAIRE, ComponentTypeEnum.SEQUENCE, ComponentTypeEnum.SUBSEQUENCE, ComponentTypeEnum.QUESTION, ComponentTypeEnum.LOOP -> false;
        };
    }

    public List<ComponentType> getComponents() {
        return this.components;
    }
}

