/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion.variable;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.lunatic.conversion.variable.CollectedVariableValuesDeserializer;
import fr.insee.lunatic.conversion.variable.ValueTypeDeserializer;
import fr.insee.lunatic.model.flat.variable.ExternalVariableValue;
import fr.insee.lunatic.model.flat.variable.ValueType;
import java.io.IOException;
import java.util.ArrayList;

public class ExternalVariableValueDeserializer
extends StdDeserializer<ExternalVariableValue> {
    public ExternalVariableValueDeserializer() {
        this(null);
    }

    ExternalVariableValueDeserializer(Class<ExternalVariableValue> valueClass) {
        super(valueClass);
    }

    public ExternalVariableValue deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode valueNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (valueNode.isValueNode()) {
            return this.deserializeScalarValue(valueNode);
        }
        if (CollectedVariableValuesDeserializer.isOneDimensionArray(valueNode)) {
            return this.deserializeArrayValue(valueNode);
        }
        if (CollectedVariableValuesDeserializer.isTwoDimensionsArray(valueNode)) {
            return this.deserializeDoubleArrayValue(valueNode);
        }
        throw new JsonParseException("Invalid content in collected variable 'values'.");
    }

    private ExternalVariableValue.Scalar deserializeScalarValue(JsonNode valueNode) throws JsonParseException {
        ExternalVariableValue.Scalar externalVariableValue = new ExternalVariableValue.Scalar();
        externalVariableValue.setScalarValue(ValueTypeDeserializer.deserializeJsonValue(valueNode));
        return externalVariableValue;
    }

    private ExternalVariableValue.Array deserializeArrayValue(JsonNode valueNode) throws JsonParseException {
        ExternalVariableValue.Array externalVariableValue = new ExternalVariableValue.Array();
        for (JsonNode jsonNode : valueNode) {
            externalVariableValue.getArrayValue().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        return externalVariableValue;
    }

    private ExternalVariableValue.DoubleArray deserializeDoubleArrayValue(JsonNode valueNode) throws JsonParseException {
        ExternalVariableValue.DoubleArray externalVariableValue = new ExternalVariableValue.DoubleArray();
        externalVariableValue.getDoubleArrayValue().clear();
        for (JsonNode jsonArray : valueNode) {
            ArrayList<ValueType> valuesList = new ArrayList<ValueType>();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            externalVariableValue.getDoubleArrayValue().add(valuesList);
        }
        return externalVariableValue;
    }
}

