/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import fr.insee.lunatic.model.flat.FieldRules;
import java.io.IOException;

public class FieldRulesSerializer
extends StdSerializer<FieldRules> {
    public FieldRulesSerializer() {
        this(null);
    }

    public FieldRulesSerializer(Class<FieldRules> t) {
        super(t);
    }

    public void serialize(FieldRules fieldRules, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        if (fieldRules.getRule() != null && fieldRules.getPatterns() != null) {
            throw new IllegalStateException("String and array values are mutually exclusive");
        }
        if (fieldRules.getRule() != null) {
            this.serializeStringRule(fieldRules, jsonGenerator);
            return;
        }
        if (fieldRules.getPatterns() != null) {
            this.serializePatternsList(fieldRules, jsonGenerator);
            return;
        }
        jsonGenerator.writeNull();
    }

    private void serializeStringRule(FieldRules fieldRules, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString(fieldRules.getRule());
    }

    private void serializePatternsList(FieldRules fieldRules, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (String pattern : fieldRules.getPatterns()) {
            jsonGenerator.writeString(pattern);
        }
        jsonGenerator.writeEndArray();
    }
}

