/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.lunatic.model.flat.SymLinksType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class SymLinksDeserializer
extends StdDeserializer<SymLinksType> {
    public SymLinksDeserializer() {
        this(null);
    }

    public SymLinksDeserializer(Class<SymLinksType> symLinksTypeClass) {
        super(symLinksTypeClass);
    }

    public SymLinksType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        SymLinksType symLinks = new SymLinksType();
        JsonNode symLinksNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<Map.Entry> symLinksEntries = new ArrayList<Map.Entry>();
        Iterator symLinksIterator = symLinksNode.fields();
        while (symLinksIterator.hasNext()) {
            symLinksEntries.add((Map.Entry)symLinksIterator.next());
        }
        if (symLinksEntries.size() != 1) {
            throw new JsonParseException("'symLinks' can only have 1 entry, got " + symLinksEntries.size());
        }
        symLinks.setName((String)((Map.Entry)symLinksEntries.get(0)).getKey());
        JsonNode linksNode = (JsonNode)((Map.Entry)symLinksEntries.get(0)).getValue();
        Iterator linksIterator = linksNode.fields();
        while (linksIterator.hasNext()) {
            Map.Entry linkEntry = (Map.Entry)linksIterator.next();
            symLinks.getLink().add(new SymLinksType.LINK((String)linkEntry.getKey(), ((JsonNode)linkEntry.getValue()).textValue()));
        }
        return symLinks;
    }
}

