/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion.variable;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.lunatic.conversion.variable.ValueTypeDeserializer;
import fr.insee.lunatic.model.flat.variable.CollectedVariableValues;
import fr.insee.lunatic.model.flat.variable.ValueType;
import java.io.IOException;
import java.util.ArrayList;

public class CollectedVariableValuesDeserializer
extends StdDeserializer<CollectedVariableValues> {
    private static final String COLLECTED_KEY = "COLLECTED";
    private static final String FORCED_KEY = "FORCED";
    private static final String EDITED_KEY = "EDITED";
    private static final String PREVIOUS_KEY = "PREVIOUS";
    private static final String INPUTTED_KEY = "INPUTTED";

    public CollectedVariableValuesDeserializer() {
        this(null);
    }

    CollectedVariableValuesDeserializer(Class<CollectedVariableValues> valuesClass) {
        super(valuesClass);
    }

    public CollectedVariableValues deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode valuesNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!valuesNode.isObject()) {
            throw new JsonParseException("Collected variable 'values' must be an object.");
        }
        if (valuesNode.isEmpty()) {
            return null;
        }
        JsonNode collectedNode = valuesNode.get(COLLECTED_KEY);
        if (collectedNode.isValueNode()) {
            return this.deserializeScalarValues(valuesNode);
        }
        if (CollectedVariableValuesDeserializer.isOneDimensionArray(collectedNode)) {
            return this.deserializeArrayValues(valuesNode);
        }
        if (CollectedVariableValuesDeserializer.isTwoDimensionsArray(collectedNode)) {
            return this.deserializeDoubleArrayValues(valuesNode);
        }
        throw new JsonParseException("Invalid content in collected variable 'values'.");
    }

    static boolean isOneDimensionArray(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            return false;
        }
        if (jsonNode.isArray() && jsonNode.isEmpty()) {
            return true;
        }
        return jsonNode.get(0).isValueNode();
    }

    static boolean isTwoDimensionsArray(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            return false;
        }
        if (jsonNode.isArray() && jsonNode.isEmpty()) {
            return false;
        }
        return jsonNode.get(0).isArray();
    }

    private CollectedVariableValues.Scalar deserializeScalarValues(JsonNode valuesNode) throws JsonParseException {
        CollectedVariableValues.Scalar collectedVariableValues = new CollectedVariableValues.Scalar();
        collectedVariableValues.setCollected(ValueTypeDeserializer.deserializeJsonValue(valuesNode.get(COLLECTED_KEY)));
        collectedVariableValues.setCollected(ValueTypeDeserializer.deserializeJsonValue(valuesNode.get(FORCED_KEY)));
        collectedVariableValues.setCollected(ValueTypeDeserializer.deserializeJsonValue(valuesNode.get(EDITED_KEY)));
        collectedVariableValues.setCollected(ValueTypeDeserializer.deserializeJsonValue(valuesNode.get(PREVIOUS_KEY)));
        collectedVariableValues.setCollected(ValueTypeDeserializer.deserializeJsonValue(valuesNode.get(INPUTTED_KEY)));
        return collectedVariableValues;
    }

    private CollectedVariableValues.Array deserializeArrayValues(JsonNode valuesNode) throws JsonParseException {
        CollectedVariableValues.Array collectedVariableValues = new CollectedVariableValues.Array();
        for (JsonNode jsonNode : valuesNode.get(COLLECTED_KEY)) {
            collectedVariableValues.getCollected().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        for (JsonNode jsonNode : valuesNode.get(FORCED_KEY)) {
            collectedVariableValues.getForced().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        for (JsonNode jsonNode : valuesNode.get(EDITED_KEY)) {
            collectedVariableValues.getEdited().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        for (JsonNode jsonNode : valuesNode.get(PREVIOUS_KEY)) {
            collectedVariableValues.getPrevious().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        for (JsonNode jsonNode : valuesNode.get(INPUTTED_KEY)) {
            collectedVariableValues.getInputted().add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
        }
        return collectedVariableValues;
    }

    private CollectedVariableValues.DoubleArray deserializeDoubleArrayValues(JsonNode valuesNode) throws JsonParseException {
        ArrayList<ValueType> valuesList;
        CollectedVariableValues.DoubleArray collectedVariableValues = new CollectedVariableValues.DoubleArray();
        collectedVariableValues.getCollected().clear();
        for (JsonNode jsonArray : valuesNode.get(COLLECTED_KEY)) {
            valuesList = new ArrayList<ValueType>();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            collectedVariableValues.getCollected().add(valuesList);
        }
        collectedVariableValues.getForced().clear();
        for (JsonNode jsonArray : valuesNode.get(FORCED_KEY)) {
            valuesList = new ArrayList();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            collectedVariableValues.getForced().add(valuesList);
        }
        collectedVariableValues.getEdited().clear();
        for (JsonNode jsonArray : valuesNode.get(EDITED_KEY)) {
            valuesList = new ArrayList();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            collectedVariableValues.getEdited().add(valuesList);
        }
        collectedVariableValues.getPrevious().clear();
        for (JsonNode jsonArray : valuesNode.get(PREVIOUS_KEY)) {
            valuesList = new ArrayList();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            collectedVariableValues.getPrevious().add(valuesList);
        }
        collectedVariableValues.getInputted().clear();
        for (JsonNode jsonArray : valuesNode.get(INPUTTED_KEY)) {
            valuesList = new ArrayList();
            for (JsonNode jsonNode : jsonArray) {
                valuesList.add(ValueTypeDeserializer.deserializeJsonValue(jsonNode));
            }
            collectedVariableValues.getInputted().add(valuesList);
        }
        return collectedVariableValues;
    }
}

