/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion.variable;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import fr.insee.lunatic.model.flat.variable.ValueType;
import java.io.IOException;

public class ValueTypeDeserializer
extends StdDeserializer<ValueType> {
    public ValueTypeDeserializer() {
        this(null);
    }

    ValueTypeDeserializer(Class<ValueType> valueTypeClass) {
        super(valueTypeClass);
    }

    public ValueType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return ValueTypeDeserializer.deserializeJsonValue(jsonNode);
    }

    static ValueType deserializeJsonValue(JsonNode jsonValue) throws JsonParseException {
        return switch (jsonValue.getNodeType()) {
            default -> throw new MatchException(null, null);
            case JsonNodeType.ARRAY, JsonNodeType.MISSING, JsonNodeType.OBJECT, JsonNodeType.POJO -> throw new JsonParseException("Invalid variable value of type " + String.valueOf(jsonValue.getNodeType()));
            case JsonNodeType.BINARY -> throw new JsonParseException("Binary json data is not supported by Lunatic-Model.");
            case JsonNodeType.BOOLEAN -> new ValueType.BooleanValue(jsonValue.booleanValue());
            case JsonNodeType.NUMBER -> new ValueType.NumberValue(jsonValue.intValue());
            case JsonNodeType.STRING -> new ValueType.StringValue(jsonValue.textValue());
            case JsonNodeType.NULL -> null;
        };
    }
}

