/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import fr.insee.lunatic.model.flat.CleaningVariableEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleaningType {
    private static final Logger log = LoggerFactory.getLogger(CleaningType.class);
    @JsonValue
    private final Map<String, CleaningVariableEntry> cleaningVariables;

    public CleaningType() {
        this.cleaningVariables = new LinkedHashMap<String, CleaningVariableEntry>();
    }

    @JsonCreator
    private CleaningType(Map<String, CleaningVariableEntry> cleaningVariables) {
        this.cleaningVariables = cleaningVariables;
    }

    public void addCleaningEntry(CleaningVariableEntry cleaningVariableEntry) {
        String cleaningVariableName = cleaningVariableEntry.getCleaningVariableName();
        if (this.cleaningVariables.containsKey(cleaningVariableName)) {
            log.warn("Overwriting cleaning variable entry '{}'", (Object)cleaningVariableName);
        }
        this.cleaningVariables.put(cleaningVariableName, cleaningVariableEntry);
    }

    public CleaningVariableEntry getCleaningEntry(String cleaningVariableName) {
        return this.cleaningVariables.get(cleaningVariableName);
    }

    public Set<String> getCleaningVariableNames() {
        return this.cleaningVariables.keySet();
    }

    public int countCleaningVariables() {
        return this.cleaningVariables.size();
    }

    public CleaningVariableEntry removeCleaningEntry(String cleaningVariableName) {
        return this.cleaningVariables.remove(cleaningVariableName);
    }
}

