/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import fr.insee.lunatic.model.flat.MissingEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingType {
    private static final Logger log = LoggerFactory.getLogger(MissingType.class);
    @JsonValue
    private final Map<String, MissingEntry> missingEntries;

    public MissingType() {
        this.missingEntries = new HashMap<String, MissingEntry>();
    }

    @JsonCreator
    private MissingType(Map<String, MissingEntry> missingEntries) {
        this.missingEntries = missingEntries;
    }

    public void addMissingEntry(MissingEntry missingEntry) {
        if (this.missingEntries.containsKey(missingEntry.getVariableName())) {
            log.warn("Overwriting missing entry for variable '{}'", (Object)missingEntry.getVariableName());
        }
        this.missingEntries.put(missingEntry.getVariableName(), missingEntry);
    }

    public MissingEntry getMissingEntry(String variableName) {
        return this.missingEntries.get(variableName);
    }

    public Set<String> getMissingKeys() {
        return this.missingEntries.keySet();
    }

    public int countMissingEntries() {
        return this.missingEntries.size();
    }

    public MissingEntry removeMissingEntry(String variableName) {
        return this.missingEntries.remove(variableName);
    }
}

