/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fr.insee.lunatic.conversion.FieldRulesDeserializer;
import fr.insee.lunatic.conversion.FieldRulesSerializer;
import java.util.ArrayList;
import java.util.List;

@JsonSerialize(using=FieldRulesSerializer.class)
@JsonDeserialize(using=FieldRulesDeserializer.class)
public class FieldRules {
    public static final String SOFT_RULE = "soft";
    public static final String ILLEGAL_STATE_MESSAGE = "String and array values are mutually exclusive";
    private String rule;
    private List<String> patterns;

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        if (this.patterns != null) {
            throw new IllegalStateException(ILLEGAL_STATE_MESSAGE);
        }
        if (!SOFT_RULE.equals(rule)) {
            throw new IllegalArgumentException("Only 'soft' value is accepted for string rule value.");
        }
        this.rule = rule;
    }

    public void addPattern(String pattern) {
        if (this.rule != null) {
            throw new IllegalStateException(ILLEGAL_STATE_MESSAGE);
        }
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        this.patterns.add(pattern);
    }

    public List<String> getPatterns() {
        return this.patterns;
    }
}

