/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import fr.insee.lunatic.model.flat.Boundaries;
import fr.insee.lunatic.model.flat.ComponentTypeEnum;
import fr.insee.lunatic.model.flat.ConditionFilterType;
import fr.insee.lunatic.model.flat.InputNumber;
import fr.insee.lunatic.model.flat.LabelType;
import fr.insee.lunatic.model.flat.NumberBoundaries;
import fr.insee.lunatic.model.flat.Option;
import fr.insee.lunatic.model.flat.Orientation;
import fr.insee.lunatic.model.flat.ResponseType;
import fr.insee.lunatic.model.flat.StringBoundaries;
import fr.insee.lunatic.model.flat.Suggester;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonPropertyOrder(value={"componentType", "orientation", "maxLength", "min", "max", "decimals", "id", "value", "label", "format", "dateFormat", "unit", "options", "response", "optionResponses", "bindingDependencies"})
public class BodyCell {
    protected Orientation orientation;
    protected String value;
    protected LabelType label;
    protected String format;
    protected String dateFormat;
    protected InputNumber.Unit unit;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<Option> options;
    private String storeName;
    protected ResponseType response;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Deprecated(since="3.4.0")
    protected List<String> bindingDependencies = new ArrayList<String>();
    protected ComponentTypeEnum componentType;
    protected BigInteger maxLength;
    @JsonIgnore
    private Boundaries boundaries;
    protected BigInteger decimals;
    protected BigInteger colspan;
    protected BigInteger rowspan;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<Suggester.OptionResponse> optionResponses;
    protected ConditionFilterType conditionFilter;
    protected ConditionFilterType conditionReadOnly;
    protected String id;

    public BodyCell() {
        this.options = new ArrayList<Option>();
        this.optionResponses = new ArrayList<Suggester.OptionResponse>();
    }

    @JsonProperty(value="unit")
    public InputNumber.Unit getUnitWrapper() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    public void setUnit(InputNumber.Unit unit) {
        this.unit = unit;
    }

    @JsonIgnore
    @Deprecated(since="3.15.2")
    public String getUnit() {
        if (this.unit == null) {
            return null;
        }
        return this.unit.getValue();
    }

    @JsonIgnore
    public LabelType getUnitLabel() {
        if (this.unit == null) {
            return null;
        }
        return this.unit.getLabel();
    }

    @JsonIgnore
    @Deprecated(since="3.15.2")
    public void setUnit(String value) {
        this.unit = new InputNumber.Unit();
        this.unit.setValue(value);
    }

    @JsonIgnore
    public void setUnit(LabelType labelType) {
        this.unit = new InputNumber.Unit();
        this.unit.setLabel(labelType);
    }

    @JsonProperty(value="min")
    public Object getMin() {
        return this.boundaries != null ? this.boundaries.getMin() : null;
    }

    @JsonProperty(value="max")
    public Object getMax() {
        return this.boundaries != null ? this.boundaries.getMax() : null;
    }

    @JsonProperty(value="min")
    public void setMin(Object min) {
        Boundaries boundaries;
        if (this.boundaries == null) {
            this.instantiateBoundaries();
        }
        if ((boundaries = this.boundaries) instanceof NumberBoundaries) {
            NumberBoundaries numberBoundaries = (NumberBoundaries)boundaries;
            if (min instanceof Number) {
                Number number = (Number)min;
                numberBoundaries.setMin(number.doubleValue());
                return;
            }
        }
        if ((boundaries = this.boundaries) instanceof StringBoundaries) {
            StringBoundaries stringBoundaries = (StringBoundaries)boundaries;
            if (min instanceof String) {
                String string = (String)min;
                stringBoundaries.setMin(string);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid or inconsistent type for min value in body cell.");
    }

    @JsonProperty(value="max")
    public void setMax(Object max) {
        Boundaries boundaries;
        if (this.boundaries == null) {
            this.instantiateBoundaries();
        }
        if ((boundaries = this.boundaries) instanceof NumberBoundaries) {
            NumberBoundaries numberBoundaries = (NumberBoundaries)boundaries;
            if (max instanceof Number) {
                Number number = (Number)max;
                numberBoundaries.setMax(number.doubleValue());
                return;
            }
        }
        if ((boundaries = this.boundaries) instanceof StringBoundaries) {
            StringBoundaries stringBoundaries = (StringBoundaries)boundaries;
            if (max instanceof String) {
                String string = (String)max;
                stringBoundaries.setMax(string);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid or inconsistent type for max value in body cell.");
    }

    private void instantiateBoundaries() {
        this.boundaries = switch (this.componentType) {
            case ComponentTypeEnum.INPUT_NUMBER -> new NumberBoundaries();
            case ComponentTypeEnum.DATEPICKER -> new StringBoundaries();
            default -> throw new IllegalStateException("Component of type '" + String.valueOf((Object)this.componentType) + "' doesn't have a min or max property.");
        };
    }

    @Generated
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Generated
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public LabelType getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(LabelType label) {
        this.label = label;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public List<Option> getOptions() {
        return this.options;
    }

    @Generated
    public void setOptions(List<Option> options) {
        this.options = options;
    }

    @Generated
    public String getStoreName() {
        return this.storeName;
    }

    @Generated
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @Generated
    public ResponseType getResponse() {
        return this.response;
    }

    @Generated
    public void setResponse(ResponseType response) {
        this.response = response;
    }

    @Deprecated
    @Generated
    public List<String> getBindingDependencies() {
        return this.bindingDependencies;
    }

    @Deprecated
    @Generated
    public void setBindingDependencies(List<String> bindingDependencies) {
        this.bindingDependencies = bindingDependencies;
    }

    @Generated
    public ComponentTypeEnum getComponentType() {
        return this.componentType;
    }

    @Generated
    public void setComponentType(ComponentTypeEnum componentType) {
        this.componentType = componentType;
    }

    @Generated
    public BigInteger getMaxLength() {
        return this.maxLength;
    }

    @Generated
    public void setMaxLength(BigInteger maxLength) {
        this.maxLength = maxLength;
    }

    @Generated
    public BigInteger getDecimals() {
        return this.decimals;
    }

    @Generated
    public void setDecimals(BigInteger decimals) {
        this.decimals = decimals;
    }

    @Generated
    public BigInteger getColspan() {
        return this.colspan;
    }

    @Generated
    public void setColspan(BigInteger colspan) {
        this.colspan = colspan;
    }

    @Generated
    public BigInteger getRowspan() {
        return this.rowspan;
    }

    @Generated
    public void setRowspan(BigInteger rowspan) {
        this.rowspan = rowspan;
    }

    @Generated
    public List<Suggester.OptionResponse> getOptionResponses() {
        return this.optionResponses;
    }

    @Generated
    public void setOptionResponses(List<Suggester.OptionResponse> optionResponses) {
        this.optionResponses = optionResponses;
    }

    @Generated
    public ConditionFilterType getConditionFilter() {
        return this.conditionFilter;
    }

    @Generated
    public void setConditionFilter(ConditionFilterType conditionFilter) {
        this.conditionFilter = conditionFilter;
    }

    @Generated
    public ConditionFilterType getConditionReadOnly() {
        return this.conditionReadOnly;
    }

    @Generated
    public void setConditionReadOnly(ConditionFilterType conditionReadOnly) {
        this.conditionReadOnly = conditionReadOnly;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

