/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.insee.lunatic.model.flat.InputNumber;
import fr.insee.lunatic.model.flat.LabelType;
import fr.insee.lunatic.model.flat.LabelTypeEnum;
import java.io.IOException;

public class UnitDeserializer
extends StdDeserializer<InputNumber.Unit> {
    public UnitDeserializer() {
        super(InputNumber.Unit.class);
    }

    protected UnitDeserializer(Class<InputNumber.Unit> unitClass) {
        super(unitClass);
    }

    public InputNumber.Unit deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode unitNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (unitNode.isTextual()) {
            InputNumber.Unit unit = new InputNumber.Unit();
            unit.setValue(unitNode.textValue());
            return unit;
        }
        if (unitNode.isObject()) {
            InputNumber.Unit unit = new InputNumber.Unit();
            LabelType label = new LabelType();
            label.setValue(unitNode.get("value").textValue());
            label.setType(LabelTypeEnum.fromValue(unitNode.get("type").textValue()));
            unit.setLabel(label);
            return unit;
        }
        return null;
    }
}

