/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.conversion;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import fr.insee.lunatic.model.flat.InputNumber;
import java.io.IOException;

public class UnitSerializer
extends StdSerializer<InputNumber.Unit> {
    public UnitSerializer() {
        super(InputNumber.Unit.class);
    }

    protected UnitSerializer(Class<InputNumber.Unit> unitClass) {
        super(unitClass);
    }

    public void serialize(InputNumber.Unit unit, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (unit.getLabel() != null) {
            this.serializeLabel(unit, jsonGenerator);
            return;
        }
        if (unit.getValue() != null) {
            this.serializeString(unit, jsonGenerator);
            return;
        }
        jsonGenerator.writeNull();
    }

    private void serializeString(InputNumber.Unit unit, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString(unit.getValue());
    }

    private void serializeLabel(InputNumber.Unit unit, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("value");
        jsonGenerator.writeString(unit.getLabel().getValue());
        jsonGenerator.writeFieldName("type");
        jsonGenerator.writeString(unit.getLabel().getType().value());
        jsonGenerator.writeEndObject();
    }
}

