/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.insee.lunatic.model.flat.ComponentType;
import fr.insee.lunatic.model.flat.ComponentTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public class Question
extends ComponentType {
    @JsonProperty(value="isMandatory")
    private Boolean mandatory;
    private final List<ComponentType> components;

    public Question() {
        this.componentType = ComponentTypeEnum.QUESTION;
        this.components = new ArrayList<ComponentType>();
    }

    public void addComponent(ComponentType component) {
        if (!Question.isQuestionComponent(component)) {
            throw new IllegalArgumentException("Component of type " + String.valueOf((Object)component.getComponentType()) + " cannot be inserted in a Question component.");
        }
        this.components.add(component);
    }

    public void addComponents(Collection<ComponentType> components) {
        components.forEach(this::addComponent);
    }

    public static boolean isQuestionComponent(ComponentType component) {
        if (component.getComponentType() == null) {
            return false;
        }
        return switch (component.getComponentType()) {
            default -> throw new MatchException(null, null);
            case ComponentTypeEnum.CHECKBOX_BOOLEAN, ComponentTypeEnum.INPUT, ComponentTypeEnum.TEXTAREA, ComponentTypeEnum.INPUT_NUMBER, ComponentTypeEnum.DATEPICKER, ComponentTypeEnum.DURATION, ComponentTypeEnum.CHECKBOX_ONE, ComponentTypeEnum.RADIO, ComponentTypeEnum.DROPDOWN, ComponentTypeEnum.SUGGESTER, ComponentTypeEnum.TEXT, ComponentTypeEnum.CHECKBOX_GROUP, ComponentTypeEnum.TABLE, ComponentTypeEnum.ROSTER_FOR_LOOP, ComponentTypeEnum.PAIRWISE_LINKS -> true;
            case ComponentTypeEnum.QUESTIONNAIRE, ComponentTypeEnum.SEQUENCE, ComponentTypeEnum.SUBSEQUENCE, ComponentTypeEnum.QUESTION, ComponentTypeEnum.FILTER_DESCRIPTION, ComponentTypeEnum.ACCORDION, ComponentTypeEnum.LOOP, ComponentTypeEnum.ROUNDABOUT -> false;
        };
    }

    @Generated
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @Generated
    public List<ComponentType> getComponents() {
        return this.components;
    }

    @JsonProperty(value="isMandatory")
    @Generated
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }
}

