/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.lunatic.model.flat.cleaning;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import fr.insee.lunatic.model.flat.cleaning.CleanedVariableEntry;
import fr.insee.lunatic.model.flat.cleaning.CleaningExpression;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleaningVariableEntry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleaningVariableEntry.class);
    private String cleaningVariableName;
    @JsonValue
    private final Map<String, List<CleaningExpression>> cleanedVariables;

    public CleaningVariableEntry(String cleaningVariableName) {
        this.cleaningVariableName = cleaningVariableName;
        this.cleanedVariables = new LinkedHashMap<String, List<CleaningExpression>>();
    }

    @JsonCreator
    private CleaningVariableEntry(Map<String, List<CleaningExpression>> cleanedVariables) {
        this.cleanedVariables = cleanedVariables;
    }

    public void addCleanedVariable(CleanedVariableEntry cleanedVariableEntry) {
        if (this.cleanedVariables.containsKey(cleanedVariableEntry.getVariableName())) {
            log.debug("Overwriting cleaned variable entry '{}' in cleaning variable entry '{}'", (Object)cleanedVariableEntry.getVariableName(), (Object)this.cleaningVariableName);
        }
        this.cleanedVariables.put(cleanedVariableEntry.getVariableName(), cleanedVariableEntry.getCleaningExpressions());
    }

    public CleanedVariableEntry getCleanedVariable(String cleanedVariableName) {
        if (this.cleanedVariables.containsKey(cleanedVariableName)) {
            CleanedVariableEntry cleanedVariableEntry = new CleanedVariableEntry(cleanedVariableName);
            cleanedVariableEntry.getCleaningExpressions().addAll((Collection<CleaningExpression>)this.cleanedVariables.get(cleanedVariableName));
            return cleanedVariableEntry;
        }
        return null;
    }

    public Set<String> getCleanedVariableNames() {
        return this.cleanedVariables.keySet();
    }

    public int countCleanedVariables() {
        return this.cleanedVariables.size();
    }

    @Generated
    public String getCleaningVariableName() {
        return this.cleaningVariableName;
    }
}

