/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.conversion.JSONSynonymsPreProcessor;
import fr.insee.pogues.exception.PoguesDeserializationException;
import fr.insee.pogues.model.Questionnaire;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(JSONDeserializer.class);

    public Questionnaire deserialize(String fileName) throws JAXBException, IOException {
        if (fileName == null || fileName.isEmpty()) {
            logger.warn("null or empty file path given!");
            return null;
        }
        logger.debug("Deserializing questionnaire from file {}", (Object)fileName);
        String fileContent = Files.readString(Path.of(fileName, new String[0]));
        String preProcessedString = new JSONSynonymsPreProcessor().transform(fileContent);
        StreamSource preProcessedStream = new StreamSource(new StringReader(preProcessedString));
        return JSONDeserializer.deserializeStreamSource(preProcessedStream);
    }

    public Questionnaire deserialize(InputStream jsonQuestionnaireInputStream) throws JAXBException {
        logger.debug("Deserializing json questionnaire from input stream.");
        String preProcessedString = new JSONSynonymsPreProcessor().transform(jsonQuestionnaireInputStream);
        StreamSource preProcessedStream = new StreamSource(new StringReader(preProcessedString));
        return JSONDeserializer.deserializeStreamSource(preProcessedStream);
    }

    private static Questionnaire deserializeStreamSource(StreamSource json) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Questionnaire.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        Questionnaire questionnaire = (Questionnaire)unmarshaller.unmarshal((Source)json, Questionnaire.class).getValue();
        if (questionnaire == null) {
            throw new PoguesDeserializationException("Deserialized questionnaire is null.");
        }
        if (questionnaire.getId() == null) {
            logger.warn("Identifier of the deserialized questionnaire is null.");
        }
        logger.debug("Questionnaire {} successfully deserialized.", (Object)questionnaire.getId());
        return questionnaire;
    }
}

