/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.model.CodeList;
import fr.insee.pogues.model.CodeLists;
import fr.insee.pogues.model.QuestionType;
import fr.insee.pogues.model.Questionnaire;
import fr.insee.pogues.model.SequenceType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLToJSONTranslator {
    private static final Logger logger = LoggerFactory.getLogger(XMLToJSONTranslator.class);
    private static final String START_DEBUG_MESSAGE = "Preparing to translate from XML to JSON";
    private final boolean monitored;

    public XMLToJSONTranslator() {
        this(false);
    }

    public XMLToJSONTranslator(boolean monitored) {
        this.monitored = monitored;
    }

    public String translate(File xmlFile) throws JAXBException {
        if (xmlFile == null) {
            return null;
        }
        StreamSource xml = new StreamSource(xmlFile);
        return this.translate(xml);
    }

    public String translate(String xmlString) throws JAXBException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        StreamSource xml = new StreamSource(new StringReader(xmlString));
        return this.translate(xml);
    }

    public String translate(StreamSource xmlStream) throws JAXBException {
        if (xmlStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Questionnaire.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        Questionnaire questionnaire = (Questionnaire)unmarshaller.unmarshal((Source)xmlStream);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)questionnaire, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateSequence(File xmlFile) throws JAXBException {
        if (xmlFile == null) {
            return null;
        }
        StreamSource xml = new StreamSource(xmlFile);
        return this.translateSequence(xml);
    }

    public String translateSequence(String xmlString) throws JAXBException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        StreamSource xml = new StreamSource(new StringReader(xmlString));
        return this.translateSequence(xml);
    }

    public String translateSequence(StreamSource xmlStream) throws JAXBException {
        if (xmlStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SequenceType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        JAXBElement jeSequence = unmarshaller.unmarshal((Source)xmlStream, SequenceType.class);
        SequenceType sequence = (SequenceType)jeSequence.getValue();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)sequence, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateQuestion(File xmlFile) throws JAXBException {
        if (xmlFile == null) {
            return null;
        }
        StreamSource xml = new StreamSource(xmlFile);
        return this.translateQuestion(xml);
    }

    public String translateQuestion(String xmlString) throws JAXBException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        StreamSource xml = new StreamSource(new StringReader(xmlString));
        return this.translateQuestion(xml);
    }

    public String translateQuestion(StreamSource xmlStream) throws JAXBException {
        if (xmlStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QuestionType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        JAXBElement jeQuestion = unmarshaller.unmarshal((Source)xmlStream, QuestionType.class);
        QuestionType question = (QuestionType)jeQuestion.getValue();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)question, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateCodeLists(File xmlFile) throws JAXBException {
        if (xmlFile == null) {
            return null;
        }
        StreamSource xml = new StreamSource(xmlFile);
        return this.translateCodeLists(xml);
    }

    public String translateCodeLists(String xmlString) throws JAXBException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        StreamSource xml = new StreamSource(new StringReader(xmlString));
        return this.translateCodeLists(xml);
    }

    public String translateCodeLists(StreamSource xmlStream) throws JAXBException {
        if (xmlStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeLists.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        CodeLists codeLists = (CodeLists)unmarshaller.unmarshal((Source)xmlStream);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeLists, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateCodeList(File xmlFile) throws JAXBException {
        if (xmlFile == null) {
            return null;
        }
        StreamSource xml = new StreamSource(xmlFile);
        return this.translateCodeList(xml);
    }

    public String translateCodeList(String xmlString) throws JAXBException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        StreamSource xml = new StreamSource(new StringReader(xmlString));
        return this.translateCodeList(xml);
    }

    public String translateCodeList(StreamSource xmlStream) throws JAXBException {
        if (xmlStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeLists.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        CodeList codeList = (CodeList)unmarshaller.unmarshal((Source)xmlStream);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeList, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    private static class UnmarshallLogger
    extends Unmarshaller.Listener {
        private UnmarshallLogger() {
        }

        public void beforeUnmarshal(Object target, Object parent) {
            logger.debug("Before unmarshalling object {}", target);
        }

        public void afterUnmarshal(Object target, Object parent) {
            logger.debug("After unmarshalling object {}", target);
        }
    }
}

