/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.mock;

import fr.insee.pogues.mock.ComponentFactory;
import fr.insee.pogues.mock.ResponseFactory;
import fr.insee.pogues.model.QuestionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionFactory {
    private static final Logger logger = LoggerFactory.getLogger(QuestionFactory.class);
    ResponseFactory responseFactory = new ResponseFactory();

    public QuestionType createQuestion(int number) {
        if (number < 0) {
            return null;
        }
        QuestionType question = this.createQuestionOnly(number);
        ComponentFactory componentFactory = new ComponentFactory();
        componentFactory.fleshoutComponent(question);
        logger.debug("Question fleshed out");
        question.getResponse().add(this.responseFactory.createResponse());
        logger.debug("Response added to the question");
        return question;
    }

    public QuestionType createQuestionOnly(int number) {
        if (number < 0) {
            return null;
        }
        logger.debug("Creating question number " + number);
        QuestionType question = new QuestionType();
        question.setId("FQU_" + number);
        question.setName("Question number " + number);
        question.getLabel().add("Label for question number " + number);
        question.getResponse().add(this.responseFactory.createSimpleTextResponse());
        return question;
    }
}

