/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.conversion.JSONSynonymsPostProcessor;
import fr.insee.pogues.model.CodeList;
import fr.insee.pogues.model.QuestionType;
import fr.insee.pogues.model.Questionnaire;
import fr.insee.pogues.model.ResponseType;
import fr.insee.pogues.model.SequenceType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSerializer {
    private boolean withoutJsonRoot;
    private static final Logger logger = LoggerFactory.getLogger(JSONSerializer.class);

    public JSONSerializer() {
    }

    public JSONSerializer(boolean withoutJsonRoot) {
        this.withoutJsonRoot = withoutJsonRoot;
    }

    public String serialize(Questionnaire questionnaire) throws JAXBException, UnsupportedEncodingException {
        if (questionnaire == null) {
            return "";
        }
        logger.debug("Serializing questionnaire " + questionnaire.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Questionnaire.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)(!this.withoutJsonRoot ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)questionnaire, (OutputStream)baos);
        String questionnaireString = baos.toString("UTF-8");
        return new JSONSynonymsPostProcessor().transform(questionnaireString);
    }

    public String serialize(SequenceType sequence) throws JAXBException, UnsupportedEncodingException {
        if (sequence == null) {
            return "";
        }
        logger.debug("Serializing sequence " + sequence.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SequenceType.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)(!this.withoutJsonRoot ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)sequence, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(CodeList codeList) throws JAXBException, UnsupportedEncodingException {
        if (codeList == null) {
            return "";
        }
        logger.debug("Serializing code list " + codeList.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeList.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)(!this.withoutJsonRoot ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeList, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(QuestionType question) throws JAXBException, UnsupportedEncodingException {
        if (question == null) {
            return "";
        }
        logger.debug("Serializing question " + question.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QuestionType.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)(!this.withoutJsonRoot ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)question, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(ResponseType response) throws JAXBException, UnsupportedEncodingException {
        if (response == null) {
            return "";
        }
        logger.debug("Serializing a Response object");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)(!this.withoutJsonRoot ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)response, (OutputStream)baos);
        return baos.toString("UTF-8");
    }
}

