/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.PostProcessingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSynonymsPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JSONSynonymsPostProcessor.class);

    public String transform(String jsonQuestionnaireString) {
        if (jsonQuestionnaireString == null) {
            logger.warn("null string given in JSON synonyms post-processing method.");
            return null;
        }
        return this.transform(new ByteArrayInputStream(jsonQuestionnaireString.getBytes()));
    }

    public String transform(InputStream jsonQuestionnaireInputStream) {
        if (jsonQuestionnaireInputStream == null) {
            logger.warn("null input stream given in JSON synonyms post-processing method.");
            return null;
        }
        logger.debug("Post-processing json questionnaire stream source...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (JsonReader jsonReader = Json.createReader((InputStream)jsonQuestionnaireInputStream);
             JsonWriter jsonWriter = Json.createWriter((OutputStream)outputStream);){
            JsonObject jsonQuestionnaire = jsonReader.readObject();
            JsonObjectBuilder jsonQuestionnaireBuilder = Json.createObjectBuilder();
            if (jsonQuestionnaire.containsKey((Object)"Questionnaire")) {
                this.editWrapperQuestionnaire(jsonQuestionnaire, jsonQuestionnaireBuilder);
            } else {
                this.editQuestionnaire(jsonQuestionnaire, jsonQuestionnaireBuilder);
            }
            jsonWriter.writeObject(jsonQuestionnaireBuilder.build());
        }
        String result = ((Object)outputStream).toString();
        try {
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new PostProcessingException("IO exception occurred when trying to close post processing output.", e);
        }
        return result;
    }

    private void editWrapperQuestionnaire(JsonObject jsonWrapperQuestionnaire, JsonObjectBuilder jsonQuestionnaireBuilder) {
        jsonWrapperQuestionnaire.forEach((key, jsonValue) -> {
            if (!"Questionnaire".equals(key)) {
                jsonQuestionnaireBuilder.add(key, jsonValue);
            } else {
                this.editQuestionnaire((JsonObject)jsonValue, jsonQuestionnaireBuilder);
            }
        });
        jsonQuestionnaireBuilder.add("Questionnaire", (JsonValue)jsonQuestionnaireBuilder.build());
    }

    private void editQuestionnaire(JsonObject jsonQuestionnaire, JsonObjectBuilder jsonQuestionnaireBuilder) {
        jsonQuestionnaire.forEach((key, jsonValue) -> {
            if (!"CodeLists".equals(key)) {
                jsonQuestionnaireBuilder.add(key, jsonValue);
            } else {
                this.editCodeLists(jsonQuestionnaireBuilder, (JsonObject)jsonValue);
            }
        });
    }

    private void editCodeLists(JsonObjectBuilder jsonQuestionnaireBuilder, JsonObject jsonCodeLists) {
        JsonObjectBuilder jsonCodeListsBuilder = Json.createObjectBuilder();
        JsonArray jsonCodeList = jsonCodeLists.getJsonArray("CodeList");
        this.editCodeListArray(jsonCodeListsBuilder, jsonCodeList);
        jsonQuestionnaireBuilder.add("CodeLists", (JsonValue)jsonCodeListsBuilder.build());
    }

    private void editCodeListArray(JsonObjectBuilder jsonCodeLists, JsonArray jsonCodeListArray) {
        JsonArrayBuilder jsonCodeListArrayBuilder = Json.createArrayBuilder();
        for (JsonValue jsonValue : jsonCodeListArray) {
            JsonObject jsonCodeList = (JsonObject)jsonValue;
            this.editCodeList(jsonCodeListArrayBuilder, jsonCodeList);
        }
        jsonCodeLists.add("CodeList", (JsonValue)jsonCodeListArrayBuilder.build());
    }

    private void editCodeList(JsonArrayBuilder jsonCodeListArrayBuilder, JsonObject jsonCodeList) {
        JsonObjectBuilder jsonCodeListBuilder = Json.createObjectBuilder();
        jsonCodeList.forEach((key, jsonValue) -> {
            if (!"SuggesterParameters".equals(key)) {
                jsonCodeListBuilder.add(key, jsonValue);
            } else {
                this.editSuggesterParameters(jsonCodeListBuilder, (JsonObject)jsonValue);
            }
        });
        jsonCodeListArrayBuilder.add((JsonValue)jsonCodeListBuilder.build());
    }

    private void editSuggesterParameters(JsonObjectBuilder jsonCodeListBuilder, JsonObject jsonSuggesterParameters) {
        JsonObjectBuilder jsonSuggesterParametersBuilder = Json.createObjectBuilder();
        jsonSuggesterParameters.forEach((key, jsonValue) -> {
            if (!"fields".equals(key)) {
                jsonSuggesterParametersBuilder.add(key, jsonValue);
            } else {
                this.editFieldsArray(jsonSuggesterParametersBuilder, (JsonArray)jsonValue);
            }
        });
        jsonCodeListBuilder.add("SuggesterParameters", (JsonValue)jsonSuggesterParametersBuilder.build());
    }

    private void editFieldsArray(JsonObjectBuilder jsonSuggesterParametersBuilder, JsonArray jsonFieldsArray) {
        JsonArrayBuilder jsonFieldsArrayBuilder = Json.createArrayBuilder();
        for (JsonValue jsonValue : jsonFieldsArray) {
            JsonObject jsonFields = (JsonObject)jsonValue;
            this.editFields(jsonFieldsArrayBuilder, jsonFields);
        }
        jsonSuggesterParametersBuilder.add("fields", (JsonValue)jsonFieldsArrayBuilder.build());
    }

    private void editFields(JsonArrayBuilder jsonFieldsArrayBuilder, JsonObject jsonFields) {
        JsonObjectBuilder jsonFieldsBuilder = Json.createObjectBuilder();
        jsonFields.forEach((key, jsonValue) -> {
            if (!"synonyms".equals(key)) {
                jsonFieldsBuilder.add(key, jsonValue);
            } else {
                this.editSynonyms(jsonFieldsBuilder, (JsonArray)jsonValue);
            }
        });
        jsonFieldsArrayBuilder.add((JsonValue)jsonFieldsBuilder.build());
    }

    private void editSynonyms(JsonObjectBuilder jsonFieldsBuilder, JsonArray jsonSynonyms) {
        JsonObjectBuilder jsonSynonymsBuilder = Json.createObjectBuilder();
        for (JsonValue synonymField : jsonSynonyms) {
            String synonymName = ((JsonObject)synonymField).getString("source");
            JsonArray synonymTarget = ((JsonObject)synonymField).getJsonArray("target");
            jsonSynonymsBuilder.add(synonymName, (JsonValue)synonymTarget);
        }
        jsonFieldsBuilder.add("synonyms", (JsonValue)jsonSynonymsBuilder.build());
    }
}

