/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.PreProcessingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSynonymsPreProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JSONSynonymsPreProcessor.class);

    public String transform(String jsonQuestionnaireString) {
        if (jsonQuestionnaireString == null) {
            logger.warn("null string given in JSON synonyms pre-processing method.");
            return null;
        }
        return this.transform(new ByteArrayInputStream(jsonQuestionnaireString.getBytes()));
    }

    public String transform(InputStream jsonQuestionnaireInputStream) {
        if (jsonQuestionnaireInputStream == null) {
            logger.warn("null input stream given in JSON synonyms pre-processing method.");
            return null;
        }
        logger.debug("Pre-processing json questionnaire stream source...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (JsonReader jsonReader = Json.createReader((InputStream)jsonQuestionnaireInputStream);
             JsonWriter jsonWriter = Json.createWriter((OutputStream)outputStream);){
            JsonObject jsonQuestionnaire = jsonReader.readObject();
            JsonObjectBuilder jsonQuestionnaireBuilder = Json.createObjectBuilder();
            JSONSynonymsPreProcessor.editQuestionnaire(jsonQuestionnaire, jsonQuestionnaireBuilder);
            jsonWriter.writeObject(jsonQuestionnaireBuilder.build());
        }
        String result = ((Object)outputStream).toString();
        try {
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new PreProcessingException("IO exception occurred when trying to close pre processing output.", e);
        }
        return result;
    }

    private static void editQuestionnaire(JsonObject jsonQuestionnaire, JsonObjectBuilder jsonQuestionnaireBuilder) {
        jsonQuestionnaire.forEach((key, jsonValue) -> {
            if (!"CodeLists".equals(key)) {
                jsonQuestionnaireBuilder.add(key, jsonValue);
            } else {
                JSONSynonymsPreProcessor.editCodeLists(jsonQuestionnaireBuilder, (JsonObject)jsonValue);
            }
        });
    }

    private static void editCodeLists(JsonObjectBuilder jsonQuestionnaireBuilder, JsonObject jsonCodeLists) {
        JsonObjectBuilder jsonCodeListsBuilder = Json.createObjectBuilder();
        JsonArray jsonCodeList = jsonCodeLists.getJsonArray("CodeList");
        JSONSynonymsPreProcessor.editCodeListArray(jsonCodeListsBuilder, jsonCodeList);
        jsonQuestionnaireBuilder.add("CodeLists", (JsonValue)jsonCodeListsBuilder.build());
    }

    private static void editCodeListArray(JsonObjectBuilder jsonCodeLists, JsonArray jsonCodeListArray) {
        JsonArrayBuilder jsonCodeListArrayBuilder = Json.createArrayBuilder();
        for (JsonValue jsonValue : jsonCodeListArray) {
            JsonObject jsonCodeList = (JsonObject)jsonValue;
            JSONSynonymsPreProcessor.editCodeList(jsonCodeListArrayBuilder, jsonCodeList);
        }
        jsonCodeLists.add("CodeList", (JsonValue)jsonCodeListArrayBuilder.build());
    }

    private static void editCodeList(JsonArrayBuilder jsonCodeListArrayBuilder, JsonObject jsonCodeList) {
        JsonObjectBuilder jsonCodeListBuilder = Json.createObjectBuilder();
        jsonCodeList.forEach((key, jsonValue) -> {
            if (!"SuggesterParameters".equals(key)) {
                jsonCodeListBuilder.add(key, jsonValue);
            } else {
                JSONSynonymsPreProcessor.editSuggesterParameters(jsonCodeListBuilder, (JsonObject)jsonValue);
            }
        });
        jsonCodeListArrayBuilder.add((JsonValue)jsonCodeListBuilder.build());
    }

    private static void editSuggesterParameters(JsonObjectBuilder jsonCodeListBuilder, JsonObject jsonSuggesterParameters) {
        JsonObjectBuilder jsonSuggesterParametersBuilder = Json.createObjectBuilder();
        jsonSuggesterParameters.forEach((key, jsonValue) -> {
            if (!"fields".equals(key)) {
                jsonSuggesterParametersBuilder.add(key, jsonValue);
            } else {
                JSONSynonymsPreProcessor.editFieldsArray(jsonSuggesterParametersBuilder, (JsonArray)jsonValue);
            }
        });
        jsonCodeListBuilder.add("SuggesterParameters", (JsonValue)jsonSuggesterParametersBuilder.build());
    }

    private static void editFieldsArray(JsonObjectBuilder jsonSuggesterParametersBuilder, JsonArray jsonFieldsArray) {
        JsonArrayBuilder jsonFieldsArrayBuilder = Json.createArrayBuilder();
        for (JsonValue jsonValue : jsonFieldsArray) {
            JsonObject jsonFields = (JsonObject)jsonValue;
            JSONSynonymsPreProcessor.editFields(jsonFieldsArrayBuilder, jsonFields);
        }
        jsonSuggesterParametersBuilder.add("fields", (JsonValue)jsonFieldsArrayBuilder.build());
    }

    private static void editFields(JsonArrayBuilder jsonFieldsArrayBuilder, JsonObject jsonFields) {
        JsonObjectBuilder jsonFieldsBuilder = Json.createObjectBuilder();
        jsonFields.forEach((key, jsonValue) -> {
            if (!"synonyms".equals(key)) {
                jsonFieldsBuilder.add(key, jsonValue);
            } else {
                JSONSynonymsPreProcessor.editSynonyms(jsonFieldsBuilder, (JsonObject)jsonValue);
            }
        });
        jsonFieldsArrayBuilder.add((JsonValue)jsonFieldsBuilder.build());
    }

    private static void editSynonyms(JsonObjectBuilder jsonFieldsBuilder, JsonObject jsonSynonyms) {
        JsonArrayBuilder jsonSynonymsArrayBuilder = Json.createArrayBuilder();
        jsonSynonyms.forEach((name, jsonValue) -> {
            JsonObjectBuilder jsonSynonymBuilder = Json.createObjectBuilder();
            jsonSynonymBuilder.add("source", name);
            jsonSynonymBuilder.add("target", jsonValue);
            jsonSynonymsArrayBuilder.add((JsonValue)jsonSynonymBuilder.build());
        });
        jsonFieldsBuilder.add("synonyms", (JsonValue)jsonSynonymsArrayBuilder.build());
    }
}

