/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.conversion.JSONSynonymsPreProcessor;
import fr.insee.pogues.model.CodeLists;
import fr.insee.pogues.model.QuestionType;
import fr.insee.pogues.model.Questionnaire;
import fr.insee.pogues.model.SequenceType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONToXMLTranslator {
    private static final Logger logger = LoggerFactory.getLogger(JSONToXMLTranslator.class);
    private static final String START_DEBUG_MESSAGE = "Preparing to translate from JSON to XML";
    private static final String POGUES_XML_NAMESPACE = "http://xml.insee.fr/schema/applis/pogues";
    private final boolean monitored;

    public JSONToXMLTranslator() {
        this(false);
    }

    public JSONToXMLTranslator(boolean monitored) {
        this.monitored = monitored;
    }

    public String translate(File jsonFile) throws JAXBException, FileNotFoundException {
        if (jsonFile == null) {
            return null;
        }
        String preProcessedString = new JSONSynonymsPreProcessor().transform(new FileInputStream(jsonFile));
        StreamSource preProcessedStream = new StreamSource(new StringReader(preProcessedString));
        return this.translate(preProcessedStream);
    }

    public String translate(String jsonString) throws JAXBException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        String preProcessedString = new JSONSynonymsPreProcessor().transform(jsonString);
        StreamSource preProcessedStream = new StreamSource(new StringReader(preProcessedString));
        return this.translate(preProcessedStream);
    }

    private String translate(StreamSource jsonStream) throws JAXBException {
        if (jsonStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Questionnaire.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        Questionnaire questionnaireNoRoot = (Questionnaire)unmarshaller.unmarshal((Source)jsonStream, Questionnaire.class).getValue();
        logger.debug("Questionnaire unmarshalled from JSON source, questionnaire id: {}", (Object)questionnaireNoRoot.getId());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        QName qName = new QName(POGUES_XML_NAMESPACE, "Questionnaire");
        JAXBElement questionnaire = new JAXBElement(qName, Questionnaire.class, (Object)questionnaireNoRoot);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)questionnaire, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateQuestion(File jsonFile) throws JAXBException {
        if (jsonFile == null) {
            return null;
        }
        StreamSource json = new StreamSource(jsonFile);
        return this.translateQuestion(json);
    }

    public String translateQuestion(String jsonString) throws JAXBException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        StreamSource json = new StreamSource(new StringReader(jsonString));
        return this.translateQuestion(json);
    }

    public String translateQuestion(StreamSource jsonStream) throws JAXBException {
        if (jsonStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QuestionType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        QuestionType questionNoRoot = (QuestionType)unmarshaller.unmarshal((Source)jsonStream, QuestionType.class).getValue();
        logger.debug("Question unmarshalled from JSON source, question id: {}", (Object)questionNoRoot.getId());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        QName qName = new QName(POGUES_XML_NAMESPACE, "Question");
        JAXBElement question = new JAXBElement(qName, QuestionType.class, (Object)questionNoRoot);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)question, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateSequence(File jsonFile) throws JAXBException {
        if (jsonFile == null) {
            return null;
        }
        StreamSource json = new StreamSource(jsonFile);
        return this.translateSequence(json);
    }

    public String translateSequence(String jsonString) throws JAXBException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        StreamSource json = new StreamSource(new StringReader(jsonString));
        return this.translateSequence(json);
    }

    public String translateSequence(StreamSource jsonStream) throws JAXBException {
        if (jsonStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SequenceType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        SequenceType sequenceNoRoot = (SequenceType)unmarshaller.unmarshal((Source)jsonStream, SequenceType.class).getValue();
        logger.debug("Sequence unmarshalled from JSON source, question id: {}", (Object)sequenceNoRoot.getId());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        QName qName = new QName(POGUES_XML_NAMESPACE, "Sequence");
        JAXBElement sequence = new JAXBElement(qName, SequenceType.class, (Object)sequenceNoRoot);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)sequence, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public String translateCodeLists(File jsonFile) throws JAXBException {
        if (jsonFile == null) {
            return null;
        }
        StreamSource json = new StreamSource(jsonFile);
        return this.translateCodeLists(json);
    }

    public String translateCodeLists(String jsonString) throws JAXBException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        StreamSource json = new StreamSource(new StringReader(jsonString));
        return this.translateCodeLists(json);
    }

    public String translateCodeLists(StreamSource jsonStream) throws JAXBException {
        if (jsonStream == null) {
            return null;
        }
        logger.debug(START_DEBUG_MESSAGE);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeLists.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        if (this.monitored) {
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallLogger());
        }
        CodeLists codeListsNoRoot = (CodeLists)unmarshaller.unmarshal((Source)jsonStream, CodeLists.class).getValue();
        logger.debug("CodeLists unmarshalled from JSON source");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        QName qName = new QName(POGUES_XML_NAMESPACE, "CodeLists");
        JAXBElement codeLists = new JAXBElement(qName, CodeLists.class, (Object)codeListsNoRoot);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeLists, (OutputStream)outputStream);
        logger.debug("Translation complete");
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    private static class UnmarshallLogger
    extends Unmarshaller.Listener {
        private UnmarshallLogger() {
        }

        public void beforeUnmarshal(Object target, Object parent) {
            logger.debug("Before unmarshalling object {}", target);
        }

        public void afterUnmarshal(Object target, Object parent) {
            logger.debug("After unmarshalling object {}", target);
        }
    }
}

