/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.conversion;

import fr.insee.pogues.model.CodeList;
import fr.insee.pogues.model.CodeLists;
import fr.insee.pogues.model.Questionnaire;
import fr.insee.pogues.model.SequenceType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSerializer {
    private static final Logger logger = LoggerFactory.getLogger(XMLSerializer.class);

    public String serialize(Questionnaire questionnaire) throws JAXBException, UnsupportedEncodingException {
        if (questionnaire == null) {
            return "";
        }
        logger.debug("Serializing questionnaire " + questionnaire.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Questionnaire.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)questionnaire, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(SequenceType sequence) throws JAXBException, UnsupportedEncodingException {
        if (sequence == null) {
            return "";
        }
        logger.debug("Serializing sequence " + sequence.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SequenceType.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)sequence, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(CodeList codeList) throws JAXBException, UnsupportedEncodingException {
        if (codeList == null) {
            return "";
        }
        logger.debug("Serializing code list " + codeList.getId());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeList.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeList, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public String serialize(CodeLists codeLists) throws JAXBException, UnsupportedEncodingException {
        if (codeLists == null) {
            return "";
        }
        logger.debug("Serializing CodeLists object");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CodeLists.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)codeLists, (OutputStream)baos);
        return baos.toString("UTF-8");
    }
}

