/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.mock;

import fr.insee.pogues.mock.CodeListFactory;
import fr.insee.pogues.mock.SequenceFactory;
import fr.insee.pogues.model.CodeList;
import fr.insee.pogues.model.CodeLists;
import fr.insee.pogues.model.ComponentGroup;
import fr.insee.pogues.model.DataCollection;
import fr.insee.pogues.model.FieldSynonym;
import fr.insee.pogues.model.FlowLogicEnum;
import fr.insee.pogues.model.Questionnaire;
import fr.insee.pogues.model.SequenceType;
import fr.insee.pogues.model.SuggesterField;
import fr.insee.pogues.model.SuggesterParametersType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireFactory {
    private static final Logger logger = LoggerFactory.getLogger(QuestionnaireFactory.class);

    public Questionnaire createQuestionnaire() {
        Questionnaire questionnaire = new Questionnaire();
        String questionnaireNumber = String.format("%03d", (int)Math.floor(Math.random() * 1000.0));
        logger.debug("Creating questionnaire number " + questionnaireNumber);
        questionnaire.setId("FQ_" + questionnaireNumber);
        questionnaire.setName("Fake questionnaire number " + questionnaireNumber);
        questionnaire.getLabel().add("Label for fake questionnaire number " + questionnaireNumber);
        questionnaire.setAgency("fr.insee");
        String surveyNumber = String.format("%02d", (int)Math.floor(Math.random() * 100.0));
        DataCollection dataCollection = new DataCollection();
        dataCollection.setId("FS_" + surveyNumber);
        dataCollection.setName("Fake survey number " + surveyNumber);
        dataCollection.setAgency("fr.insee");
        dataCollection.setUri("http://ddi:fr.insee:DataCollection.INSEE-FAKE-DC-1.1");
        questionnaire.getDataCollection().add(dataCollection);
        logger.debug("Survey added to questionnaire number " + questionnaireNumber);
        SequenceFactory sequenceFactory = new SequenceFactory();
        SequenceType sequence = sequenceFactory.createSequence(1);
        questionnaire.getChild().addAll(sequence.getChild());
        ComponentGroup group = new ComponentGroup();
        group.setId("PENDING_COMPONENTS");
        group.setName("Questions waiting to be created");
        group.getLabel().add("Label for pending components group");
        SequenceType groupComponentContainer = sequenceFactory.createSequence(99);
        group.getMember().addAll(groupComponentContainer.getChild());
        questionnaire.getComponentGroup().add(group);
        logger.debug("Component group added to questionnaire number " + questionnaireNumber);
        CodeListFactory codeListFactory = new CodeListFactory();
        questionnaire.setCodeLists(codeListFactory.createCodeLists());
        logger.debug("Code list container added to questionnaire number " + questionnaireNumber);
        return questionnaire;
    }

    public Questionnaire createMinimalQuestionnaire() {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setId("test");
        questionnaire.setAgency("Insee");
        questionnaire.setFinal(true);
        questionnaire.setName("Without root questionnaire");
        questionnaire.setFlowLogic(FlowLogicEnum.FILTER);
        return questionnaire;
    }

    public Questionnaire createQuestionnaireWithSynonyms() {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setId("test");
        CodeLists codeLists = new CodeLists();
        CodeList codeList = new CodeList();
        SuggesterParametersType suggesterParametersType = new SuggesterParametersType();
        SuggesterField suggesterField = new SuggesterField();
        FieldSynonym fieldSynonym = new FieldSynonym();
        fieldSynonym.setSource("foo");
        fieldSynonym.getTarget().add("one");
        fieldSynonym.getTarget().add("two");
        suggesterField.getSynonyms().add(fieldSynonym);
        suggesterParametersType.getFields().add(suggesterField);
        codeList.setSuggesterParameters(suggesterParametersType);
        codeLists.getCodeList().add(codeList);
        questionnaire.setCodeLists(codeLists);
        return questionnaire;
    }
}

