/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.pogues.mock;

import fr.insee.pogues.mock.ComponentFactory;
import fr.insee.pogues.mock.QuestionFactory;
import fr.insee.pogues.model.SequenceType;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFactory {
    public static int ONLY_SEQUENCES_DEPTH = 1;
    public static int ONLY_QUESTIONS_DEPTH = 3;
    public static int MAX_CHILDREN_NUMBER = 5;
    private static final Logger logger = LoggerFactory.getLogger(SequenceFactory.class);

    public SequenceType createSequence(int number) {
        if (number <= 0) {
            return null;
        }
        logger.debug("Creating sequence number " + number);
        int depth = String.valueOf(number).length();
        if (depth > ONLY_QUESTIONS_DEPTH) {
            return null;
        }
        SequenceType sequence = new SequenceType();
        ComponentFactory componentFactory = new ComponentFactory();
        QuestionFactory questionFactory = new QuestionFactory();
        sequence.setId("FSQ_" + number);
        sequence.setName("Sequence number " + number);
        sequence.getLabel().add("Label for sequence number " + number);
        sequence.setDepth(BigInteger.valueOf(depth));
        componentFactory.fleshoutComponent(sequence);
        int numberOfChildren = (int)Math.floor(Math.random() * (double)(MAX_CHILDREN_NUMBER + 1));
        logger.debug("Sequence " + sequence.getId() + " fleshed out, number of children to be added: " + numberOfChildren);
        for (int childIndex = 0; childIndex <= numberOfChildren; ++childIndex) {
            boolean childIsSequence;
            int childNumber = number * 10 + childIndex;
            boolean bl = childIsSequence = depth <= ONLY_SEQUENCES_DEPTH || depth != ONLY_QUESTIONS_DEPTH && Math.random() < 0.5;
            if (childIsSequence) {
                sequence.getChild().add(this.createSequence(childNumber));
                continue;
            }
            sequence.getChild().add(questionFactory.createQuestion(childNumber));
        }
        return sequence;
    }
}

