/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.processors;

import fr.insee.vtl.engine.utils.KeyExtractor;
import fr.insee.vtl.engine.utils.MapCollector;
import fr.insee.vtl.model.AggregationExpression;
import fr.insee.vtl.model.Analytics;
import fr.insee.vtl.model.DataPointRuleset;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.HierarchicalRuleset;
import fr.insee.vtl.model.InMemoryDataset;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ProcessingEngineFactory;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;

public class InMemoryProcessingEngine
implements ProcessingEngine {
    public DatasetExpression executeCalc(final DatasetExpression expression, final Map<String, ResolvableExpression> expressions, Map<String, Dataset.Role> roles, Map<String, String> expressionStrings) {
        final Structured.DataStructure newStructure = new Structured.DataStructure(expression.getDataStructure());
        for (String columnName : expressions.keySet()) {
            newStructure.put((Object)columnName, (Object)new Structured.Component(columnName, expressions.get(columnName).getType(), roles.get(columnName), Boolean.valueOf(true)));
        }
        return new DatasetExpression((Positioned)expression){

            public Dataset resolve(Map<String, Object> context) {
                Dataset dataset = expression.resolve(context);
                List result = dataset.getDataPoints().stream().map(dataPoint -> {
                    Structured.DataPoint newDataPoint = new Structured.DataPoint(newStructure, (Collection)dataPoint);
                    for (String columnName : expressions.keySet()) {
                        newDataPoint.set(columnName, ((ResolvableExpression)expressions.get(columnName)).resolve(dataPoint));
                    }
                    return newDataPoint;
                }).collect(Collectors.toList());
                return new InMemoryDataset(result, newStructure);
            }

            public Structured.DataStructure getDataStructure() {
                return newStructure;
            }
        };
    }

    public DatasetExpression executeFilter(final DatasetExpression expression, final ResolvableExpression filter, String filterText) {
        return new DatasetExpression((Positioned)expression){

            public Structured.DataStructure getDataStructure() {
                return expression.getDataStructure();
            }

            public Dataset resolve(Map<String, Object> context) {
                Dataset resolve = expression.resolve(context);
                List result = resolve.getDataPoints().stream().filter(map -> {
                    Object res = filter.resolve(map);
                    if (res == null) {
                        return false;
                    }
                    return (Boolean)res;
                }).collect(Collectors.toList());
                return new InMemoryDataset(result, this.getDataStructure());
            }
        };
    }

    public DatasetExpression executeRename(final DatasetExpression expression, final Map<String, String> fromTo) {
        if (fromTo.isEmpty()) {
            return expression;
        }
        List structure = expression.getDataStructure().values().stream().map(component -> !fromTo.containsKey(component.getName()) ? component : new Structured.Component((String)fromTo.get(component.getName()), component.getType(), component.getRole(), component.getNullable())).collect(Collectors.toList());
        final Structured.DataStructure renamedStructure = new Structured.DataStructure(structure);
        return new DatasetExpression((Positioned)expression){

            public Dataset resolve(Map<String, Object> context) {
                List result = expression.resolve(context).getDataPoints().stream().map(dataPoint -> {
                    Structured.DataPoint newDataPoint = new Structured.DataPoint(renamedStructure, (Collection)dataPoint);
                    for (String fromName : fromTo.keySet()) {
                        String toName = (String)fromTo.get(fromName);
                        newDataPoint.set(toName, dataPoint.get(fromName));
                    }
                    return newDataPoint;
                }).collect(Collectors.toList());
                return new InMemoryDataset(result, (Map)this.getDataStructure());
            }

            public Structured.DataStructure getDataStructure() {
                return renamedStructure;
            }
        };
    }

    public DatasetExpression executeProject(final DatasetExpression expression, List<String> columnNames) {
        List structure = expression.getDataStructure().values().stream().filter(component -> columnNames.contains(component.getName())).collect(Collectors.toList());
        final Structured.DataStructure newStructure = new Structured.DataStructure(structure);
        return new DatasetExpression((Positioned)expression){

            public Dataset resolve(Map<String, Object> context) {
                List columnNames = this.getColumnNames();
                List result = expression.resolve(context).getDataPoints().stream().map(data -> {
                    Structured.DataPoint projectedDataPoint = new Structured.DataPoint(newStructure);
                    for (String column : columnNames) {
                        projectedDataPoint.set(column, data.get(column));
                    }
                    return projectedDataPoint;
                }).collect(Collectors.toList());
                return new InMemoryDataset(result, this.getDataStructure());
            }

            public Structured.DataStructure getDataStructure() {
                return newStructure;
            }
        };
    }

    public DatasetExpression executeUnion(final List<DatasetExpression> datasets) {
        return new DatasetExpression((Positioned)datasets.get(0)){

            public Dataset resolve(Map<String, Object> context) {
                Stream stream = Stream.empty();
                for (DatasetExpression datasetExpression : datasets) {
                    Dataset dataset = datasetExpression.resolve(context);
                    stream = Stream.concat(stream, dataset.getDataPoints().stream());
                }
                List data = stream.distinct().collect(Collectors.toList());
                return new InMemoryDataset(data, (Map)this.getDataStructure());
            }

            public Structured.DataStructure getDataStructure() {
                return ((DatasetExpression)datasets.get(0)).getDataStructure();
            }
        };
    }

    public DatasetExpression executeAggr(final DatasetExpression expression, List<String> groupBy, final Map<String, AggregationExpression> collectorMap) {
        final KeyExtractor keyExtractor = new KeyExtractor(groupBy);
        LinkedHashMap<String, Structured.Component> newStructure = new LinkedHashMap<String, Structured.Component>();
        for (Structured.Component component : expression.getDataStructure().values()) {
            if (!groupBy.contains(component.getName())) continue;
            newStructure.put(component.getName(), component);
        }
        for (Map.Entry entry : collectorMap.entrySet()) {
            newStructure.put((String)entry.getKey(), new Structured.Component((String)entry.getKey(), ((AggregationExpression)entry.getValue()).getType(), Dataset.Role.MEASURE, Boolean.valueOf(true)));
        }
        final Structured.DataStructure structure = new Structured.DataStructure(newStructure.values());
        return new DatasetExpression((Positioned)expression){

            public Dataset resolve(Map<String, Object> context) {
                List data = expression.resolve(Map.of()).getDataPoints();
                MapCollector collector = new MapCollector(structure, collectorMap);
                List collect = data.stream().collect(Collectors.groupingBy(keyExtractor, collector)).entrySet().stream().map(e -> {
                    Structured.DataPoint dataPoint = (Structured.DataPoint)e.getValue();
                    Map identifiers = (Map)e.getKey();
                    for (Map.Entry identifierElement : identifiers.entrySet()) {
                        dataPoint.set((String)identifierElement.getKey(), identifierElement.getValue());
                    }
                    return dataPoint;
                }).collect(Collectors.toList());
                return new InMemoryDataset(collect, (Map)structure);
            }

            public Structured.DataStructure getDataStructure() {
                return structure;
            }
        };
    }

    public DatasetExpression executeSimpleAnalytic(DatasetExpression dataset, String targetColumnName, Analytics.Function function, String columnName, List<String> partitionBy, Map<String, Analytics.Order> orderBy, Analytics.WindowSpec window) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeLeadOrLagAn(DatasetExpression dataset, String targetColumnName, Analytics.Function function, String columnName, int offset, List<String> partitionBy, Map<String, Analytics.Order> orderBy) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeRatioToReportAn(DatasetExpression dataset, String targetColumnName, Analytics.Function function, String columnName, List<String> partitionBy) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeRankAn(DatasetExpression dataset, String targetColumnName, Analytics.Function function, List<String> partitionBy, Map<String, Analytics.Order> orderBy) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeLeftJoin(Map<String, DatasetExpression> datasets, List<Structured.Component> components) {
        Iterator<DatasetExpression> iterator = datasets.values().iterator();
        DatasetExpression leftMost = iterator.next();
        while (iterator.hasNext()) {
            leftMost = this.handleLeftJoin(components, leftMost, iterator.next());
        }
        return leftMost;
    }

    public DatasetExpression executeInnerJoin(Map<String, DatasetExpression> datasets, List<Structured.Component> components) {
        Iterator<DatasetExpression> iterator = datasets.values().iterator();
        DatasetExpression leftMost = iterator.next();
        while (iterator.hasNext()) {
            leftMost = this.handleInnerJoin(components, leftMost, iterator.next());
        }
        return leftMost;
    }

    public DatasetExpression executeCrossJoin(Map<String, DatasetExpression> datasets, List<Structured.Component> identifiers) {
        Iterator<DatasetExpression> iterator = datasets.values().iterator();
        DatasetExpression leftMost = iterator.next();
        while (iterator.hasNext()) {
            leftMost = this.handleCrossJoin(identifiers, leftMost, iterator.next());
        }
        return leftMost;
    }

    public DatasetExpression executeFullJoin(Map<String, DatasetExpression> datasets, List<Structured.Component> identifiers) {
        Iterator<DatasetExpression> iterator = datasets.values().iterator();
        DatasetExpression leftMost = iterator.next();
        while (iterator.hasNext()) {
            leftMost = this.handleFullJoin(identifiers, leftMost, iterator.next());
        }
        return leftMost;
    }

    public DatasetExpression executeValidateDPruleset(DataPointRuleset dpr, DatasetExpression dataset, String output, Positioned pos) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeValidationSimple(DatasetExpression dsE, ResolvableExpression erCodeE, ResolvableExpression erLevelE, DatasetExpression imbalanceE, String output, Positioned pos) {
        throw new UnsupportedOperationException();
    }

    public DatasetExpression executeHierarchicalValidation(DatasetExpression dsE, HierarchicalRuleset hr, String componentID, String validationMode, String inputMode, String validationOutput, Positioned pos) {
        throw new UnsupportedOperationException();
    }

    private Structured.DataStructure createCommonStructure(List<Structured.Component> identifiers, DatasetExpression left, DatasetExpression right) {
        ArrayList<Structured.Component> components = new ArrayList<Structured.Component>(identifiers);
        for (Structured.Component component : left.getDataStructure().values()) {
            if (identifiers.contains(component)) continue;
            components.add(component);
        }
        for (Structured.Component component : right.getDataStructure().values()) {
            if (identifiers.contains(component)) continue;
            components.add(component);
        }
        return new Structured.DataStructure(components);
    }

    private Comparator<Structured.DataPoint> createPredicate(List<Structured.Component> identifiers) {
        return (dl, dr) -> {
            for (Structured.Component identifier : identifiers) {
                if (Objects.equals(dl.get(identifier.getName()), dr.get(identifier.getName()))) continue;
                return -1;
            }
            return 0;
        };
    }

    private DatasetExpression handleInnerJoin(List<Structured.Component> identifiers, final DatasetExpression left, final DatasetExpression right) {
        final Structured.DataStructure structure = this.createCommonStructure(identifiers, left, right);
        final Comparator<Structured.DataPoint> predicate = this.createPredicate(identifiers);
        return new DatasetExpression((Positioned)left){

            public Dataset resolve(Map<String, Object> context) {
                List leftPoints = left.resolve(context).getDataPoints();
                List rightPoints = right.resolve(context).getDataPoints();
                ArrayList<Structured.DataPoint> result = new ArrayList<Structured.DataPoint>();
                for (Structured.DataPoint leftPoint : leftPoints) {
                    ArrayList<Structured.DataPoint> matches = new ArrayList<Structured.DataPoint>();
                    for (Structured.DataPoint rightPoint : rightPoints) {
                        if (predicate.compare(leftPoint, rightPoint) != 0) continue;
                        matches.add(rightPoint);
                    }
                    if (matches.isEmpty()) continue;
                    Structured.DataPoint mergedPoint = new Structured.DataPoint(structure);
                    for (String leftColumn : left.getDataStructure().keySet()) {
                        mergedPoint.set(leftColumn, leftPoint.get(leftColumn));
                    }
                    for (Structured.DataPoint match : matches) {
                        Structured.DataPoint matchPoint = new Structured.DataPoint(structure, (Collection)mergedPoint);
                        for (String rightColumn : right.getDataStructure().keySet()) {
                            matchPoint.set(rightColumn, match.get(rightColumn));
                        }
                        result.add(matchPoint);
                    }
                }
                return new InMemoryDataset(result, (Map)structure);
            }

            public Structured.DataStructure getDataStructure() {
                return structure;
            }
        };
    }

    private DatasetExpression handleFullJoin(List<Structured.Component> identifiers, DatasetExpression left, DatasetExpression right) {
        return this.executeUnion(List.of(this.handleLeftJoin(identifiers, left, right), this.handleLeftJoin(identifiers, right, left)));
    }

    private DatasetExpression handleLeftJoin(List<Structured.Component> identifiers, final DatasetExpression left, final DatasetExpression right) {
        final Structured.DataStructure structure = this.createCommonStructure(identifiers, left, right);
        final Comparator<Structured.DataPoint> predicate = this.createPredicate(identifiers);
        return new DatasetExpression((Positioned)left){

            public Dataset resolve(Map<String, Object> context) {
                List leftPoints = left.resolve(context).getDataPoints();
                List rightPoints = right.resolve(context).getDataPoints();
                ArrayList<Structured.DataPoint> result = new ArrayList<Structured.DataPoint>();
                for (Structured.DataPoint leftPoint : leftPoints) {
                    ArrayList<Structured.DataPoint> matches = new ArrayList<Structured.DataPoint>();
                    for (Structured.DataPoint rightPoint : rightPoints) {
                        if (predicate.compare(leftPoint, rightPoint) != 0) continue;
                        matches.add(rightPoint);
                    }
                    Structured.DataPoint mergedPoint = new Structured.DataPoint(structure);
                    for (String leftColumn : left.getDataStructure().keySet()) {
                        mergedPoint.set(leftColumn, leftPoint.get(leftColumn));
                    }
                    if (matches.isEmpty()) {
                        result.add(mergedPoint);
                        continue;
                    }
                    for (Structured.DataPoint match : matches) {
                        Structured.DataPoint matchPoint = new Structured.DataPoint(structure, (Collection)mergedPoint);
                        for (String rightColumn : right.getDataStructure().keySet()) {
                            matchPoint.set(rightColumn, match.get(rightColumn));
                        }
                        result.add(matchPoint);
                    }
                }
                return new InMemoryDataset(result, (Map)structure);
            }

            public Structured.DataStructure getDataStructure() {
                return structure;
            }
        };
    }

    private DatasetExpression handleCrossJoin(List<Structured.Component> identifiers, final DatasetExpression left, final DatasetExpression right) {
        final Structured.DataStructure structure = this.createCommonStructure(identifiers, left, right);
        return new DatasetExpression((Positioned)left){

            public Dataset resolve(Map<String, Object> context) {
                List leftPoints = left.resolve(context).getDataPoints();
                List rightPoints = right.resolve(context).getDataPoints();
                ArrayList<Structured.DataPoint> result = new ArrayList<Structured.DataPoint>();
                for (Structured.DataPoint leftPoint : leftPoints) {
                    for (Structured.DataPoint rightPoint : rightPoints) {
                        Structured.DataPoint mergedPoint = new Structured.DataPoint(structure);
                        for (String leftColumn : left.getDataStructure().keySet()) {
                            mergedPoint.set(leftColumn, leftPoint.get(leftColumn));
                        }
                        for (String rightColumn : right.getDataStructure().keySet()) {
                            mergedPoint.set(rightColumn, rightPoint.get(rightColumn));
                        }
                        result.add(mergedPoint);
                    }
                }
                return new InMemoryDataset(result, (Map)structure);
            }

            public Structured.DataStructure getDataStructure() {
                return structure;
            }
        };
    }

    public static class Factory
    implements ProcessingEngineFactory {
        public String getName() {
            return "memory";
        }

        public ProcessingEngine getProcessingEngine(ScriptEngine engine) {
            return new InMemoryProcessingEngine();
        }
    }
}

