/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class GroupByVisitor
extends VtlBaseVisitor<List<String>> {
    private final Structured.DataStructure dataStructure;

    public GroupByVisitor(Structured.DataStructure dataStructure) {
        this.dataStructure = dataStructure;
    }

    private String getName(VtlParser.ComponentIDContext ctx) {
        String text = ctx.getText();
        if (text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public List<String> visitGroupByOrExcept(VtlParser.GroupByOrExceptContext ctx) {
        ArrayList<String> componentNames = new ArrayList<String>(ctx.componentID().size());
        for (VtlParser.ComponentIDContext component : ctx.componentID()) {
            String componentName = this.getName(component);
            if (!this.dataStructure.containsKey((Object)componentName)) {
                throw new VtlRuntimeException(new InvalidArgumentException(String.format("unknown component %s", componentName), VtlScriptEngine.fromContext((ParseTree)component)));
            }
            componentNames.add(componentName);
        }
        if (ctx.BY() != null) {
            return componentNames;
        }
        if (ctx.EXCEPT() != null) {
            return this.dataStructure.keySet().stream().filter(componentNames::contains).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException();
    }
}

