/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class NumericFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;
    private final String UNKNOWN_OPERATOR = "unknown operator ";

    public NumericFunctionsVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long ceil(Number value) {
        if (value == null) {
            return null;
        }
        return (long)Math.ceil(value.doubleValue());
    }

    public static Long floor(Number value) {
        if (value == null) {
            return null;
        }
        return (long)Math.floor(value.doubleValue());
    }

    public static Double abs(Number value) {
        if (value == null) {
            return null;
        }
        return Math.abs(value.doubleValue());
    }

    public static Double exp(Number value) {
        if (value == null) {
            return null;
        }
        return Math.exp(value.doubleValue());
    }

    public static Double ln(Number value) {
        if (value == null) {
            return null;
        }
        return Math.log(value.doubleValue());
    }

    public static Double sqrt(Number value) {
        if (value == null) {
            return null;
        }
        if (value.doubleValue() < 0.0) {
            throw new IllegalArgumentException("operand has to be 0 or positive");
        }
        return Math.sqrt(value.doubleValue());
    }

    public static Double round(Number value, Long decimal) {
        if (decimal == null) {
            decimal = 0L;
        }
        if (value == null) {
            return null;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value.doubleValue()));
        bd = bd.setScale(decimal.intValue(), RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static Double trunc(Number value, Long decimal) {
        if (decimal == null) {
            decimal = 0L;
        }
        if (value == null) {
            return null;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value.doubleValue()));
        bd = bd.setScale(decimal.intValue(), RoundingMode.DOWN);
        return bd.doubleValue();
    }

    public static Double mod(Number left, Number right) {
        if (left == null || right == null) {
            return null;
        }
        if (right.doubleValue() == 0.0) {
            return left.doubleValue();
        }
        return left.doubleValue() % right.doubleValue() * (double)(right.doubleValue() < 0.0 ? -1 : 1);
    }

    public static Double power(Number left, Number right) {
        if (left == null || right == null) {
            return null;
        }
        return Math.pow(left.doubleValue(), right.doubleValue());
    }

    public static Double log(Number operand, Number base) {
        if (operand == null || base == null) {
            return null;
        }
        if (operand.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("operand must be positive");
        }
        if (base.doubleValue() < 1.0) {
            throw new IllegalArgumentException("base must be greater or equal than 1");
        }
        return Math.log(operand.doubleValue()) / Math.log(base.doubleValue());
    }

    public ResolvableExpression visitUnaryNumeric(VtlParser.UnaryNumericContext ctx) {
        try {
            VtlParser.ExprContext expr = ctx.expr();
            List<ResolvableExpression> parameter = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)expr));
            switch (ctx.op.getType()) {
                case 124: {
                    return this.genericFunctionsVisitor.invokeFunction("ceil", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 125: {
                    return this.genericFunctionsVisitor.invokeFunction("floor", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 73: {
                    return this.genericFunctionsVisitor.invokeFunction("abs", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 96: {
                    return this.genericFunctionsVisitor.invokeFunction("exp", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 75: {
                    return this.genericFunctionsVisitor.invokeFunction("ln", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 126: {
                    return this.genericFunctionsVisitor.invokeFunction("sqrt", parameter, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitUnaryWithOptionalNumeric(VtlParser.UnaryWithOptionalNumericContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr()), ctx.optionalExpr() == null ? ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)c -> 0L) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.optionalExpr()));
            switch (ctx.op.getType()) {
                case 78: {
                    return this.genericFunctionsVisitor.invokeFunction("round", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 77: {
                    return this.genericFunctionsVisitor.invokeFunction("trunc", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitBinaryNumeric(VtlParser.BinaryNumericContext ctx) {
        try {
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right));
            switch (ctx.op.getType()) {
                case 80: {
                    return this.genericFunctionsVisitor.invokeFunction("mod", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 79: {
                    return this.genericFunctionsVisitor.invokeFunction("power", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 76: {
                    return this.genericFunctionsVisitor.invokeFunction("log", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

