/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.expressions;

import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;

public class CastExpression
extends ResolvableExpression {
    private final Class<?> target;
    private final ResolvableExpression expr;
    private final String isNotSupported = " is not supported";

    public CastExpression(Positioned position, ResolvableExpression expr, String mask, Class<?> target) throws VtlScriptException {
        super(position);
        this.target = target;
        Class source = expr.getType();
        if (source.equals(target)) {
            this.expr = expr;
        } else if (String.class.equals((Object)source)) {
            this.expr = this.castString(expr, mask);
        } else if (Boolean.class.equals((Object)source)) {
            this.expr = this.castBoolean(expr);
        } else if (Long.class.equals((Object)source)) {
            this.expr = this.castLong(expr);
        } else if (Double.class.equals((Object)source)) {
            this.expr = this.castDouble(expr);
        } else if (Instant.class.equals((Object)source)) {
            if (mask == null || mask.isEmpty()) {
                throw new InvalidArgumentException("cannot cast date: no mask specified", position);
            }
            this.expr = this.castInstant(expr, mask);
        } else {
            throw new VtlScriptException("cast unsupported on expression of type: " + expr.getType(), position);
        }
    }

    public ResolvableExpression castBoolean(ResolvableExpression expr) {
        Class<?> outputClass = this.getType();
        if (outputClass.equals(String.class)) {
            return ResolvableExpression.withType(String.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Boolean exprValue = (Boolean)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return exprValue.toString();
            });
        }
        if (outputClass.equals(Long.class)) {
            return ResolvableExpression.withType(Long.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Boolean exprValue = (Boolean)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return exprValue != false ? 1L : 0L;
            });
        }
        if (outputClass.equals(Double.class)) {
            return ResolvableExpression.withType(Double.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Boolean exprValue = (Boolean)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return exprValue != false ? 1.0 : 0.0;
            });
        }
        throw new ClassCastException("Cast Boolean to " + outputClass + " is not supported");
    }

    private ResolvableExpression castDouble(ResolvableExpression expr) {
        Class<?> outputClass = this.getType();
        if (outputClass.equals(String.class)) {
            return ResolvableExpression.withType(String.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Double exprValue = (Double)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return exprValue.toString();
            });
        }
        if (outputClass.equals(Long.class)) {
            return ResolvableExpression.withType(Long.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Double exprValue = (Double)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                if (exprValue % 1.0 != 0.0) {
                    throw new UnsupportedOperationException(exprValue + " can not be casted into integer");
                }
                return exprValue.longValue();
            });
        }
        if (outputClass.equals(Double.class)) {
            return ResolvableExpression.withType(Double.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> (Double)expr.resolve(context));
        }
        if (outputClass.equals(Boolean.class)) {
            return ResolvableExpression.withType(Boolean.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Double exprValue = (Double)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return !exprValue.equals(0.0);
            });
        }
        throw new ClassCastException("Cast Double to " + outputClass + " is not supported");
    }

    private ResolvableExpression castInstant(ResolvableExpression expr, String mask) {
        Class<?> outputClass = this.getType();
        if (outputClass.equals(String.class)) {
            return ResolvableExpression.withType(String.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Object value = expr.resolve(context);
                Instant exprValue = value instanceof LocalDate ? ((LocalDate)value).atStartOfDay().toInstant(ZoneOffset.UTC) : (Instant)value;
                if (exprValue == null) {
                    return null;
                }
                DateTimeFormatter maskFormatter = DateTimeFormatter.ofPattern(mask);
                return maskFormatter.format(exprValue.atOffset(ZoneOffset.UTC));
            });
        }
        throw new ClassCastException("Cast Date to " + outputClass + " is not supported");
    }

    private ResolvableExpression castLong(ResolvableExpression expr) {
        Class<?> outputClass = this.getType();
        if (outputClass.equals(String.class)) {
            return ResolvableExpression.withType(String.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Long exprValue = (Long)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return exprValue.toString();
            });
        }
        if (outputClass.equals(Double.class)) {
            return ResolvableExpression.withType(Double.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Long exprValue = (Long)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return (double)exprValue;
            });
        }
        if (outputClass.equals(Boolean.class)) {
            return ResolvableExpression.withType(Boolean.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                Long exprValue = (Long)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return !exprValue.equals(0L);
            });
        }
        throw new ClassCastException("Cast Long to " + outputClass + " is not supported");
    }

    private ResolvableExpression castString(ResolvableExpression expr, String mask) {
        Class<?> outputClass = this.getType();
        if (outputClass.equals(Long.class)) {
            return ResolvableExpression.withType(Long.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                String exprValue = (String)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return Long.valueOf(exprValue);
            });
        }
        if (outputClass.equals(Double.class)) {
            return ResolvableExpression.withType(Double.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                String exprValue = (String)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return Double.valueOf(exprValue);
            });
        }
        if (outputClass.equals(Boolean.class)) {
            return ResolvableExpression.withType(Boolean.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                String exprValue = (String)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                return Boolean.valueOf(exprValue);
            });
        }
        if (outputClass.equals(Instant.class)) {
            return ResolvableExpression.withType(Instant.class).withPosition((Positioned)expr).using((VtlFunction & Serializable)context -> {
                if (mask == null) {
                    return null;
                }
                String exprValue = (String)expr.resolve(context);
                if (exprValue == null) {
                    return null;
                }
                DateTimeFormatter maskFormatter = DateTimeFormatter.ofPattern(mask).withZone(ZoneOffset.UTC);
                try {
                    return LocalDateTime.parse(exprValue, maskFormatter).toInstant(ZoneOffset.UTC);
                }
                catch (DateTimeParseException dtp) {
                    return LocalDate.parse(exprValue, maskFormatter).atStartOfDay().toInstant(ZoneOffset.UTC);
                }
            });
        }
        throw new ClassCastException("Cast String to " + outputClass + " is not supported");
    }

    public Object resolve(Map<String, Object> context) {
        return this.expr.resolve(context);
    }

    public Class<?> getType() {
        return this.target;
    }
}

