/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.utils;

import fr.insee.vtl.model.Structured;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MapCollector
implements Collector<Structured.DataPoint, Structured.DataPoint, Structured.DataPoint> {
    private final Structured.DataStructure structure;
    private final Map<String, Supplier<Object>> supplierMap = new HashMap<String, Supplier<Object>>();
    private final Map<String, BiConsumer<Object, Structured.DataPoint>> accumulatorMap = new HashMap<String, BiConsumer<Object, Structured.DataPoint>>();
    private final Map<String, BinaryOperator<Object>> combinerMap = new HashMap<String, BinaryOperator<Object>>();
    private final Map<String, Function<Object, Object>> finisherMap = new HashMap<String, Function<Object, Object>>();

    public MapCollector(Structured.DataStructure structure, Map<String, ? extends Collector<Structured.DataPoint, Object, Object>> collectorMap) {
        this.structure = Objects.requireNonNull(structure);
        if (!structure.keySet().containsAll(collectorMap.keySet())) {
            throw new IllegalArgumentException("inconsistent collector map");
        }
        for (Map.Entry<String, ? extends Collector<Structured.DataPoint, Object, Object>> entry : collectorMap.entrySet()) {
            this.supplierMap.put(entry.getKey(), entry.getValue().supplier());
            this.accumulatorMap.put(entry.getKey(), entry.getValue().accumulator());
            this.combinerMap.put(entry.getKey(), entry.getValue().combiner());
            this.finisherMap.put(entry.getKey(), entry.getValue().finisher());
        }
    }

    @Override
    public Supplier<Structured.DataPoint> supplier() {
        return () -> {
            Structured.DataPoint dataPoint = new Structured.DataPoint(this.structure);
            for (Map.Entry<String, Supplier<Object>> entry : this.supplierMap.entrySet()) {
                String column = entry.getKey();
                dataPoint.set(column, entry.getValue().get());
            }
            return dataPoint;
        };
    }

    @Override
    public BiConsumer<Structured.DataPoint, Structured.DataPoint> accumulator() {
        return (map, context) -> {
            for (Map.Entry<String, BiConsumer<Object, Structured.DataPoint>> entry : this.accumulatorMap.entrySet()) {
                String column = entry.getKey();
                Object accumulatorValue = map.get(column);
                entry.getValue().accept(accumulatorValue, (Structured.DataPoint)context);
            }
        };
    }

    @Override
    public BinaryOperator<Structured.DataPoint> combiner() {
        return (map, map2) -> {
            for (Map.Entry<String, BinaryOperator<Object>> entry : this.combinerMap.entrySet()) {
                String column = entry.getKey();
                Object newValue = entry.getValue().apply(map.get(column), map2.get(column));
                map.set(column, newValue);
            }
            return map;
        };
    }

    @Override
    public Function<Structured.DataPoint, Structured.DataPoint> finisher() {
        return map -> {
            for (Map.Entry<String, Function<Object, Object>> entry : this.finisherMap.entrySet()) {
                String column = entry.getKey();
                map.set(column, entry.getValue().apply(map.get(column)));
            }
            return map;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of(Collector.Characteristics.UNORDERED);
    }
}

