/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.utils.TypeChecking;
import fr.insee.vtl.engine.visitors.AnalyticsVisitor;
import fr.insee.vtl.engine.visitors.GroupByVisitor;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.AggregationExpression;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class ClauseVisitor
extends VtlBaseVisitor<DatasetExpression> {
    private final DatasetExpression datasetExpression;
    private final ExpressionVisitor componentExpressionVisitor;
    private final ProcessingEngine processingEngine;

    public ClauseVisitor(DatasetExpression datasetExpression, ProcessingEngine processingEngine, VtlScriptEngine engine) {
        this.datasetExpression = Objects.requireNonNull(datasetExpression);
        Map<String, Object> componentMap = datasetExpression.getDataStructure().values().stream().collect(Collectors.toMap(Structured.Component::getName, component -> component));
        this.componentExpressionVisitor = new ExpressionVisitor(componentMap, processingEngine, engine);
        this.processingEngine = Objects.requireNonNull(processingEngine);
    }

    public static String getName(VtlParser.ComponentIDContext context) {
        String text = context.getText();
        if (text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    static String getSource(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(new Interval(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex()));
    }

    private static AggregationExpression convertToAggregation(VtlParser.AggrDatasetContext groupFunctionCtx, ResolvableExpression expression) {
        if (groupFunctionCtx.SUM() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.sum((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.AVG() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.avg((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.COUNT() != null) {
            return AggregationExpression.count();
        }
        if (groupFunctionCtx.MAX() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.max((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.MIN() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.min((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.MEDIAN() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.median((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.STDDEV_POP() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.stdDevPop((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.STDDEV_SAMP() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.stdDevSamp((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.VAR_POP() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.varPop((ResolvableExpression)numberExpression);
        }
        if (groupFunctionCtx.VAR_SAMP() != null) {
            ResolvableExpression numberExpression = TypeChecking.assertNumber(expression, (ParseTree)groupFunctionCtx.expr());
            return AggregationExpression.varSamp((ResolvableExpression)numberExpression);
        }
        throw new VtlRuntimeException(new VtlScriptException("not implemented", VtlScriptEngine.fromContext((ParseTree)groupFunctionCtx)));
    }

    public DatasetExpression visitKeepOrDropClause(VtlParser.KeepOrDropClauseContext ctx) {
        boolean keep = ctx.op.getType() == 31;
        Set names = ctx.componentID().stream().map(ClauseVisitor::getName).collect(Collectors.toSet());
        List columnNames = this.datasetExpression.getDataStructure().values().stream().map(Structured.Component::getName).filter(name -> keep == names.contains(name)).collect(Collectors.toList());
        return this.processingEngine.executeProject(this.datasetExpression, columnNames);
    }

    public DatasetExpression visitCalcClause(VtlParser.CalcClauseContext ctx) {
        LinkedHashMap<String, ResolvableExpression> expressions = new LinkedHashMap<String, ResolvableExpression>();
        LinkedHashMap<String, String> expressionStrings = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Dataset.Role> roles = new LinkedHashMap<String, Dataset.Role>();
        DatasetExpression currentDatasetExpression = this.datasetExpression;
        for (VtlParser.CalcClauseItemContext calcCtx : ctx.calcClauseItem()) {
            Dataset.Role columnRole;
            String columnName = ClauseVisitor.getName(calcCtx.componentID());
            Dataset.Role role = columnRole = calcCtx.componentRole() == null ? Dataset.Role.MEASURE : Dataset.Role.valueOf((String)calcCtx.componentRole().getText().toUpperCase());
            if (calcCtx.expr() instanceof VtlParser.FunctionsExpressionContext && ((VtlParser.FunctionsExpressionContext)calcCtx.expr()).functions() instanceof VtlParser.AnalyticFunctionsContext) {
                AnalyticsVisitor analyticsVisitor = new AnalyticsVisitor(this.processingEngine, currentDatasetExpression, columnName);
                VtlParser.FunctionsExpressionContext functionExprCtx = (VtlParser.FunctionsExpressionContext)calcCtx.expr();
                VtlParser.AnalyticFunctionsContext anFuncCtx = (VtlParser.AnalyticFunctionsContext)functionExprCtx.functions();
                currentDatasetExpression = (DatasetExpression)analyticsVisitor.visit((ParseTree)anFuncCtx);
                continue;
            }
            ResolvableExpression calc = (ResolvableExpression)this.componentExpressionVisitor.visit((ParseTree)calcCtx);
            expressions.put(columnName, calc);
            expressionStrings.put(columnName, ClauseVisitor.getSource((ParserRuleContext)calcCtx.expr()));
            roles.put(columnName, columnRole);
        }
        if (!expressionStrings.isEmpty()) {
            currentDatasetExpression = this.processingEngine.executeCalc(currentDatasetExpression, expressions, roles, expressionStrings);
        }
        return currentDatasetExpression;
    }

    public DatasetExpression visitFilterClause(VtlParser.FilterClauseContext ctx) {
        ResolvableExpression filter = (ResolvableExpression)this.componentExpressionVisitor.visit((ParseTree)ctx.expr());
        return this.processingEngine.executeFilter(this.datasetExpression, filter, ClauseVisitor.getSource((ParserRuleContext)ctx.expr()));
    }

    public DatasetExpression visitRenameClause(VtlParser.RenameClauseContext ctx) {
        LinkedHashMap<String, String> fromTo = new LinkedHashMap<String, String>();
        HashSet<String> renamed = new HashSet<String>();
        for (VtlParser.RenameClauseItemContext renameCtx : ctx.renameClauseItem()) {
            String toNameString = ClauseVisitor.getName(renameCtx.toName);
            String fromNameString = ClauseVisitor.getName(renameCtx.fromName);
            if (!renamed.add(toNameString)) {
                throw new VtlRuntimeException(new InvalidArgumentException(String.format("duplicate column: %s", toNameString), VtlScriptEngine.fromContext((ParseTree)renameCtx)));
            }
            fromTo.put(fromNameString, toNameString);
        }
        return this.processingEngine.executeRename(this.datasetExpression, fromTo);
    }

    public DatasetExpression visitAggrClause(VtlParser.AggrClauseContext ctx) {
        List aggregationsWithExpressions = ctx.aggregateClause().aggrFunctionClause().stream().filter(agg -> agg.aggrOperatorsGrouping() instanceof VtlParser.AggrDatasetContext).collect(Collectors.toList());
        Map<String, ResolvableExpression> expressions = aggregationsWithExpressions.stream().collect(Collectors.toMap(agg -> ClauseVisitor.getName(agg.componentID()), agg -> (ResolvableExpression)this.componentExpressionVisitor.visit((ParseTree)((VtlParser.AggrDatasetContext)agg.aggrOperatorsGrouping()).expr())));
        Map<String, Dataset.Role> roles = aggregationsWithExpressions.stream().collect(Collectors.toMap(agg -> ClauseVisitor.getName(agg.componentID()), agg -> agg.componentRole() == null ? Dataset.Role.MEASURE : Dataset.Role.valueOf((String)agg.componentRole().getText().toUpperCase())));
        Map<String, String> expressionStrings = aggregationsWithExpressions.stream().collect(Collectors.toMap(agg -> ClauseVisitor.getName(agg.componentID()), agg -> ClauseVisitor.getSource((ParserRuleContext)agg.aggrOperatorsGrouping())));
        DatasetExpression normalizedDataset = this.processingEngine.executeCalc(this.datasetExpression, expressions, roles, expressionStrings);
        Structured.DataStructure dataStructure = this.datasetExpression.getDataStructure();
        List groupBy = (List)new GroupByVisitor(dataStructure).visit((ParseTree)ctx);
        Structured.DataStructure normalizedStructure = normalizedDataset.getDataStructure();
        LinkedHashMap<String, AggregationExpression> collectorMap = new LinkedHashMap<String, AggregationExpression>();
        for (VtlParser.AggrFunctionClauseContext functionCtx : ctx.aggregateClause().aggrFunctionClause()) {
            final String alias = ClauseVisitor.getName(functionCtx.componentID());
            if (normalizedStructure.containsKey((Object)alias)) {
                final Structured.Component normalizedComponent = (Structured.Component)normalizedStructure.get((Object)alias);
                AggregationExpression aggregationFunction = ClauseVisitor.convertToAggregation((VtlParser.AggrDatasetContext)functionCtx.aggrOperatorsGrouping(), new ResolvableExpression(VtlScriptEngine.fromContext((ParseTree)ctx)){

                    public Object resolve(Map<String, Object> context) {
                        return context.get(alias);
                    }

                    public Class<?> getType() {
                        return normalizedComponent.getType();
                    }
                });
                collectorMap.put(alias, aggregationFunction);
                continue;
            }
            collectorMap.put(alias, AggregationExpression.count());
        }
        return this.processingEngine.executeAggr(normalizedDataset, groupBy, collectorMap);
    }
}

