/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class ArithmeticVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public ArithmeticVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long multiplication(Long valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA * valueB;
    }

    public static Double multiplication(Long valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA.doubleValue() * valueB;
    }

    public static Double multiplication(Double valueA, Long valueB) {
        return ArithmeticVisitor.multiplication(valueB, valueA);
    }

    public static Double multiplication(Double valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA * valueB;
    }

    public static Double division(Long valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA.doubleValue() / valueB;
    }

    public static Double division(Double valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA / valueB.doubleValue();
    }

    public static Double division(Long valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return (double)valueA.longValue() / (double)valueB.longValue();
    }

    public static Double division(Double valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA / valueB;
    }

    public ResolvableExpression visitArithmeticExpr(VtlParser.ArithmeticExprContext ctx) {
        try {
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right));
            switch (ctx.op.getType()) {
                case 15: {
                    return this.genericFunctionsVisitor.invokeFunction("multiplication", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 16: {
                    return this.genericFunctionsVisitor.invokeFunction("division", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

