/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class ConditionalVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public ConditionalVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long ifThenElse(Boolean condition, Long thenExpr, Long elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Double ifThenElse(Boolean condition, Double thenExpr, Double elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static String ifThenElse(Boolean condition, String thenExpr, String elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Boolean ifThenElse(Boolean condition, Boolean thenExpr, Boolean elseExpr) {
        if (condition == null) {
            return null;
        }
        return condition != false ? thenExpr : elseExpr;
    }

    public static Long nvl(Long value, Long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Double nvl(Double value, Double defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Double nvl(Double value, Long defaultValue) {
        return value == null ? defaultValue.doubleValue() : value.doubleValue();
    }

    public static Double nvl(Long value, Double defaultValue) {
        return value == null ? defaultValue.doubleValue() : value.doubleValue();
    }

    public static String nvl(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Boolean nvl(Boolean value, Boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    public ResolvableExpression visitIfExpr(VtlParser.IfExprContext ctx) {
        try {
            ResolvableExpression conditionalExpr = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.conditionalExpr);
            ResolvableExpression thenExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.thenExpr);
            ResolvableExpression elseExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.elseExpr);
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            ResolvableExpression expression = this.genericFunctionsVisitor.invokeFunction("ifThenElse", List.of(conditionalExpr, thenExpression, elseExpression), position);
            Class actualType = thenExpression.getType();
            return new CastExpression(position, expression, actualType);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitNvlAtom(VtlParser.NvlAtomContext ctx) {
        try {
            ResolvableExpression expression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left);
            ResolvableExpression defaultExpression = (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right);
            Positioned position = VtlScriptEngine.fromContext((ParseTree)ctx);
            return this.genericFunctionsVisitor.invokeFunction("nvl", List.of(expression, defaultExpression), position);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    static class CastExpression
    extends ResolvableExpression {
        private final Class<?> type;
        private final ResolvableExpression expression;

        CastExpression(Positioned pos, ResolvableExpression expression, Class<?> type) {
            super(pos);
            this.type = type;
            this.expression = expression;
        }

        public Object resolve(Map<String, Object> context) {
            return this.type.cast(this.expression.resolve(context));
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

