/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.model.ConstantExpression;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import org.antlr.v4.runtime.tree.ParseTree;

public class ConstantVisitor
extends VtlBaseVisitor<ConstantExpression> {
    public ConstantExpression visitConstant(VtlParser.ConstantContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        if (ctx.INTEGER_CONSTANT() != null) {
            return new ConstantExpression((Object)Long.parseLong(ctx.getText()), pos);
        }
        if (ctx.NUMBER_CONSTANT() != null) {
            return new ConstantExpression((Object)Double.parseDouble(ctx.getText()), pos);
        }
        if (ctx.BOOLEAN_CONSTANT() != null) {
            return new ConstantExpression((Object)Boolean.parseBoolean(ctx.getText()), pos);
        }
        if (ctx.STRING_CONSTANT() != null) {
            String text = ctx.getText();
            return new ConstantExpression((Object)text.substring(1, text.length() - 1), pos);
        }
        if (ctx.NULL_CONSTANT() != null) {
            return new ConstantExpression(null, pos);
        }
        throw new UnsupportedOperationException("unknown constant type " + ctx);
    }
}

