/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.UnimplementedException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.AnalyticsVisitor;
import fr.insee.vtl.engine.visitors.ClauseVisitor;
import fr.insee.vtl.engine.visitors.expression.ArithmeticExprOrConcatVisitor;
import fr.insee.vtl.engine.visitors.expression.ArithmeticVisitor;
import fr.insee.vtl.engine.visitors.expression.BooleanVisitor;
import fr.insee.vtl.engine.visitors.expression.ComparisonVisitor;
import fr.insee.vtl.engine.visitors.expression.ConditionalVisitor;
import fr.insee.vtl.engine.visitors.expression.ConstantVisitor;
import fr.insee.vtl.engine.visitors.expression.UnaryVisitor;
import fr.insee.vtl.engine.visitors.expression.VarIdVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.ComparisonFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.DistanceFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.JoinFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.NumericFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.SetFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.StringFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.TimeFunctionsVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.ValidationFunctionsVisitor;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.exceptions.InvalidTypeException;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private static final ConstantVisitor CONSTANT_VISITOR = new ConstantVisitor();
    private final VarIdVisitor varIdVisitor;
    private final BooleanVisitor booleanVisitor;
    private final ArithmeticVisitor arithmeticVisitor;
    private final ArithmeticExprOrConcatVisitor arithmeticExprOrConcatVisitor;
    private final UnaryVisitor unaryVisitor;
    private final ComparisonVisitor comparisonVisitor;
    private final ConditionalVisitor conditionalVisitor;
    private final StringFunctionsVisitor stringFunctionsVisitor;
    private final ComparisonFunctionsVisitor comparisonFunctionsVisitor;
    private final NumericFunctionsVisitor numericFunctionsVisitor;
    private final SetFunctionsVisitor setFunctionsVisitor;
    private final JoinFunctionsVisitor joinFunctionsVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;
    private final DistanceFunctionsVisitor distanceFunctionsVisitor;
    private final TimeFunctionsVisitor timeFunctionsVisitor;
    private final ValidationFunctionsVisitor validationFunctionsVisitor;
    private final ProcessingEngine processingEngine;
    private final VtlScriptEngine engine;

    public ExpressionVisitor(Map<String, Object> context, ProcessingEngine processingEngine, VtlScriptEngine engine) {
        Objects.requireNonNull(context);
        this.genericFunctionsVisitor = new GenericFunctionsVisitor(this, engine);
        this.varIdVisitor = new VarIdVisitor(context);
        this.booleanVisitor = new BooleanVisitor(this, this.genericFunctionsVisitor);
        this.arithmeticVisitor = new ArithmeticVisitor(this, this.genericFunctionsVisitor);
        this.arithmeticExprOrConcatVisitor = new ArithmeticExprOrConcatVisitor(this, this.genericFunctionsVisitor);
        this.unaryVisitor = new UnaryVisitor(this, this.genericFunctionsVisitor);
        this.comparisonVisitor = new ComparisonVisitor(this, this.genericFunctionsVisitor);
        this.conditionalVisitor = new ConditionalVisitor(this, this.genericFunctionsVisitor);
        this.stringFunctionsVisitor = new StringFunctionsVisitor(this, this.genericFunctionsVisitor);
        this.comparisonFunctionsVisitor = new ComparisonFunctionsVisitor(this, this.genericFunctionsVisitor);
        this.setFunctionsVisitor = new SetFunctionsVisitor(this, processingEngine);
        this.joinFunctionsVisitor = new JoinFunctionsVisitor(this, processingEngine);
        this.numericFunctionsVisitor = new NumericFunctionsVisitor(this, this.genericFunctionsVisitor);
        this.distanceFunctionsVisitor = new DistanceFunctionsVisitor(this, this.genericFunctionsVisitor);
        this.timeFunctionsVisitor = new TimeFunctionsVisitor();
        this.validationFunctionsVisitor = new ValidationFunctionsVisitor(this, processingEngine, engine);
        this.processingEngine = Objects.requireNonNull(processingEngine);
        this.engine = Objects.requireNonNull(engine);
    }

    public ResolvableExpression visitConstant(VtlParser.ConstantContext ctx) {
        return (ResolvableExpression)CONSTANT_VISITOR.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitVarID(VtlParser.VarIDContext ctx) {
        return (ResolvableExpression)this.varIdVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitBooleanExpr(VtlParser.BooleanExprContext ctx) {
        return (ResolvableExpression)this.booleanVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitMembershipExpr(VtlParser.MembershipExprContext ctx) {
        try {
            String componentName;
            ResolvableExpression ds = (ResolvableExpression)this.visit((ParseTree)ctx.expr());
            if (!(ds instanceof DatasetExpression)) {
                throw new InvalidTypeException(Dataset.class, ds.getType(), VtlScriptEngine.fromContext((ParseTree)ctx.expr()));
            }
            Structured.DataStructure structure = ((DatasetExpression)ds).getDataStructure();
            if (!structure.containsKey((Object)(componentName = ctx.simpleComponentId().getText()))) {
                throw new VtlScriptException(String.format("column %s not found in %s", componentName, ctx.expr().getText()), VtlScriptEngine.fromContext((ParseTree)ctx));
            }
            ArrayList components = structure.values().stream().filter(Structured.Component::isIdentifier).map(Structured.Component::getName).collect(Collectors.toCollection(ArrayList::new));
            components.add(componentName);
            return this.engine.getProcessingEngine().executeProject((DatasetExpression)ds, (List)components);
        }
        catch (VtlScriptException vse) {
            throw new VtlRuntimeException(vse);
        }
    }

    public ResolvableExpression visitArithmeticExpr(VtlParser.ArithmeticExprContext ctx) {
        return (ResolvableExpression)this.arithmeticVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitArithmeticExprOrConcat(VtlParser.ArithmeticExprOrConcatContext ctx) {
        return (ResolvableExpression)this.arithmeticExprOrConcatVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitUnaryExpr(VtlParser.UnaryExprContext ctx) {
        return (ResolvableExpression)this.unaryVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitParenthesisExpr(VtlParser.ParenthesisExprContext ctx) {
        return (ResolvableExpression)this.visit((ParseTree)ctx.expr());
    }

    public ResolvableExpression visitComparisonExpr(VtlParser.ComparisonExprContext ctx) {
        return (ResolvableExpression)this.comparisonVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitInNotInExpr(VtlParser.InNotInExprContext ctx) {
        return (ResolvableExpression)this.comparisonVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitIfExpr(VtlParser.IfExprContext ctx) {
        return (ResolvableExpression)this.conditionalVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitNvlAtom(VtlParser.NvlAtomContext ctx) {
        return (ResolvableExpression)this.conditionalVisitor.visit((ParseTree)ctx);
    }

    public ResolvableExpression visitStringFunctions(VtlParser.StringFunctionsContext ctx) {
        return (ResolvableExpression)this.stringFunctionsVisitor.visit((ParseTree)ctx.stringOperators());
    }

    public ResolvableExpression visitComparisonFunctions(VtlParser.ComparisonFunctionsContext ctx) {
        return (ResolvableExpression)this.comparisonFunctionsVisitor.visit((ParseTree)ctx.comparisonOperators());
    }

    public ResolvableExpression visitSetFunctions(VtlParser.SetFunctionsContext ctx) {
        return (ResolvableExpression)this.setFunctionsVisitor.visit((ParseTree)ctx.setOperators());
    }

    public ResolvableExpression visitJoinFunctions(VtlParser.JoinFunctionsContext ctx) {
        return (ResolvableExpression)this.joinFunctionsVisitor.visitJoinFunctions(ctx);
    }

    public ResolvableExpression visitGenericFunctions(VtlParser.GenericFunctionsContext ctx) {
        return (ResolvableExpression)this.genericFunctionsVisitor.visitGenericFunctions(ctx);
    }

    public ResolvableExpression visitNumericFunctions(VtlParser.NumericFunctionsContext ctx) {
        return (ResolvableExpression)this.numericFunctionsVisitor.visit((ParseTree)ctx.numericOperators());
    }

    public ResolvableExpression visitDistanceFunctions(VtlParser.DistanceFunctionsContext ctx) {
        return (ResolvableExpression)this.distanceFunctionsVisitor.visit((ParseTree)ctx.distanceOperators());
    }

    public ResolvableExpression visitTimeFunctions(VtlParser.TimeFunctionsContext ctx) {
        return (ResolvableExpression)this.timeFunctionsVisitor.visit((ParseTree)ctx.timeOperators());
    }

    public ResolvableExpression visitValidationFunctions(VtlParser.ValidationFunctionsContext ctx) {
        return (ResolvableExpression)this.validationFunctionsVisitor.visit((ParseTree)ctx.validationOperators());
    }

    public ResolvableExpression visitClauseExpr(VtlParser.ClauseExprContext ctx) {
        DatasetExpression datasetExpression = (DatasetExpression)this.visit((ParseTree)ctx.dataset);
        ClauseVisitor clauseVisitor = new ClauseVisitor(datasetExpression, this.processingEngine, this.engine);
        return (ResolvableExpression)clauseVisitor.visit((ParseTree)ctx.clause);
    }

    public ResolvableExpression visitRatioToReportAn(VtlParser.RatioToReportAnContext ctx) {
        DatasetExpression datasetExpression = (DatasetExpression)this.visit((ParseTree)ctx.expr());
        String dsName = ctx.expr().getText();
        Structured.DataStructure structure = datasetExpression.getDataStructure();
        List ids = structure.getIdentifiers();
        LinkedHashMap<CallSite, DatasetExpression> analytics = new LinkedHashMap<CallSite, DatasetExpression>();
        for (Structured.Component measure : structure.getMeasures()) {
            List colNames = Stream.concat(ids.stream(), Stream.of(measure)).map(Structured.Component::getName).collect(Collectors.toList());
            DatasetExpression tempDs = this.processingEngine.executeProject(datasetExpression, colNames);
            tempDs = this.processingEngine.executeRename(tempDs, Map.of(measure.getName(), dsName));
            String targetColumnName = ctx.op.getText() + "_" + measure.getName();
            AnalyticsVisitor analyticsVisitor = new AnalyticsVisitor(this.processingEngine, tempDs, targetColumnName);
            DatasetExpression result = (DatasetExpression)analyticsVisitor.visit((ParseTree)ctx);
            result = this.processingEngine.executeRename(result, Map.of(targetColumnName, measure.getName()));
            result = this.processingEngine.executeProject(result, result.getColumnNames().stream().filter(n -> !n.equals(dsName)).collect(Collectors.toList()));
            analytics.put((CallSite)((Object)targetColumnName), result);
        }
        return this.processingEngine.executeInnerJoin(analytics);
    }

    public ResolvableExpression visitLagOrLeadAn(VtlParser.LagOrLeadAnContext ctx) {
        DatasetExpression datasetExpression = (DatasetExpression)this.visit((ParseTree)ctx.expr());
        String dsName = ctx.expr().getText();
        Structured.DataStructure structure = datasetExpression.getDataStructure();
        List ids = structure.getIdentifiers();
        LinkedHashMap<CallSite, DatasetExpression> analytics = new LinkedHashMap<CallSite, DatasetExpression>();
        for (Structured.Component measure : structure.getMeasures()) {
            List colNames = Stream.concat(ids.stream(), Stream.of(measure)).map(Structured.Component::getName).collect(Collectors.toList());
            DatasetExpression tempDs = this.processingEngine.executeProject(datasetExpression, colNames);
            tempDs = this.processingEngine.executeRename(tempDs, Map.of(measure.getName(), dsName));
            String targetColumnName = ctx.op.getText() + "_" + measure.getName();
            AnalyticsVisitor analyticsVisitor = new AnalyticsVisitor(this.processingEngine, tempDs, targetColumnName);
            DatasetExpression result = (DatasetExpression)analyticsVisitor.visit((ParseTree)ctx);
            result = this.processingEngine.executeRename(result, Map.of(targetColumnName, measure.getName()));
            result = this.processingEngine.executeProject(result, result.getColumnNames().stream().filter(n -> !n.equals(dsName)).collect(Collectors.toList()));
            analytics.put((CallSite)((Object)targetColumnName), result);
        }
        return this.processingEngine.executeInnerJoin(analytics);
    }

    public DatasetExpression visitAnSimpleFunction(VtlParser.AnSimpleFunctionContext ctx) {
        DatasetExpression datasetExpression = (DatasetExpression)this.visit((ParseTree)ctx.expr());
        String dsName = ctx.expr().getText();
        Structured.DataStructure structure = datasetExpression.getDataStructure();
        List ids = structure.getIdentifiers();
        LinkedHashMap<CallSite, DatasetExpression> analytics = new LinkedHashMap<CallSite, DatasetExpression>();
        for (Structured.Component measure : structure.getMeasures()) {
            List colNames = Stream.concat(ids.stream(), Stream.of(measure)).map(Structured.Component::getName).collect(Collectors.toList());
            DatasetExpression tempDs = this.processingEngine.executeProject(datasetExpression, colNames);
            tempDs = this.processingEngine.executeRename(tempDs, Map.of(measure.getName(), dsName));
            String targetColumnName = ctx.op.getText() + "_" + measure.getName();
            AnalyticsVisitor analyticsVisitor = new AnalyticsVisitor(this.processingEngine, tempDs, targetColumnName);
            DatasetExpression result = (DatasetExpression)analyticsVisitor.visit((ParseTree)ctx);
            result = this.processingEngine.executeRename(result, Map.of(targetColumnName, measure.getName()));
            result = this.processingEngine.executeProject(result, result.getColumnNames().stream().filter(n -> !n.equals(dsName)).collect(Collectors.toList()));
            analytics.put((CallSite)((Object)targetColumnName), result);
        }
        return this.processingEngine.executeInnerJoin(analytics);
    }

    public ResolvableExpression visitFunctionsExpression(VtlParser.FunctionsExpressionContext ctx) {
        ResolvableExpression expr = (ResolvableExpression)super.visitFunctionsExpression(ctx);
        if (Objects.isNull(expr)) {
            VtlParser.FunctionsContext functionsContext = ctx.functions();
            String functionName = functionsContext.getStart().getText();
            throw new VtlRuntimeException(new UnimplementedException("the function " + functionName + " is not yet implemented", VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        return expr;
    }
}

