/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class UnaryVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public UnaryVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = genericFunctionsVisitor;
    }

    public static Long plus(Long right) {
        return right;
    }

    public static Double plus(Double right) {
        return right;
    }

    public static Long minus(Long right) {
        if (right == null) {
            return null;
        }
        return -right.longValue();
    }

    public static Double minus(Double right) {
        if (right == null) {
            return null;
        }
        return -right.doubleValue();
    }

    public static Boolean not(Boolean right) {
        if (right == null) {
            return null;
        }
        return right == false;
    }

    public ResolvableExpression visitUnaryExpr(VtlParser.UnaryExprContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right));
            switch (ctx.op.getType()) {
                case 13: {
                    return this.genericFunctionsVisitor.invokeFunction("plus", parameters, pos);
                }
                case 14: {
                    return this.genericFunctionsVisitor.invokeFunction("minus", parameters, pos);
                }
                case 39: {
                    return this.genericFunctionsVisitor.invokeFunction("not", parameters, pos);
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

