/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class DistanceFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public DistanceFunctionsVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long levenshtein(String stringA, String stringB) {
        if (stringA == null || stringB == null) {
            return null;
        }
        return (long)LevenshteinDistance.getDefaultInstance().apply((CharSequence)stringA, (CharSequence)stringB);
    }

    public ResolvableExpression visitLevenshteinAtom(VtlParser.LevenshteinAtomContext ctx) {
        try {
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right));
            return this.genericFunctionsVisitor.invokeFunction("levenshtein", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

