/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;

public class StringFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    static final Pattern LTRIM = Pattern.compile("^\\s+");
    static final Pattern RTRIM = Pattern.compile("\\s+$");
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public StringFunctionsVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static String trim(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public static String ltrim(String value) {
        if (value == null) {
            return null;
        }
        return LTRIM.matcher(value).replaceAll("");
    }

    public static String rtrim(String value) {
        if (value == null) {
            return null;
        }
        return RTRIM.matcher(value).replaceAll("");
    }

    public static String ucase(String value) {
        if (value == null) {
            return null;
        }
        return value.toUpperCase();
    }

    public static String lcase(String value) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase();
    }

    public static Long len(String value) {
        if (value == null) {
            return null;
        }
        return value.length();
    }

    public static String substr(String value, Long start, Long len) {
        long end;
        if (value == null) {
            return null;
        }
        if (start == null) {
            start = 1L;
        }
        if (len == null) {
            len = value.length();
        }
        if (start > (long)value.length()) {
            return "";
        }
        if (start != 0L) {
            start = start - 1L;
        }
        if ((end = start + len) > (long)value.length()) {
            return value.substring(Math.toIntExact(start));
        }
        return value.substring(Math.toIntExact(start), Math.toIntExact(end));
    }

    public static String replace(String value, String pattern, String replacement) {
        if (value == null || pattern == null) {
            return null;
        }
        if (replacement == null) {
            replacement = "";
        }
        return value.replaceAll(pattern, replacement);
    }

    public static Long instr(String v, String v2, Long start, Long occurence) {
        if (v == null || v2 == null) {
            return null;
        }
        if (start == null) {
            start = 0L;
        }
        if (occurence == null) {
            occurence = 1L;
        }
        return (long)StringUtils.ordinalIndexOf((CharSequence)v.substring(start.intValue()), (CharSequence)v2, (int)occurence.intValue()) + 1L;
    }

    public ResolvableExpression visitUnaryStringFunction(VtlParser.UnaryStringFunctionContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            List<ResolvableExpression> parameters = List.of((ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr()));
            switch (ctx.op.getType()) {
                case 83: {
                    return this.genericFunctionsVisitor.invokeFunction("trim", parameters, pos);
                }
                case 120: {
                    return this.genericFunctionsVisitor.invokeFunction("ltrim", parameters, pos);
                }
                case 121: {
                    return this.genericFunctionsVisitor.invokeFunction("rtrim", parameters, pos);
                }
                case 84: {
                    return this.genericFunctionsVisitor.invokeFunction("ucase", parameters, pos);
                }
                case 85: {
                    return this.genericFunctionsVisitor.invokeFunction("lcase", parameters, pos);
                }
                case 81: {
                    return this.genericFunctionsVisitor.invokeFunction("len", parameters, pos);
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx.op.getText());
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitSubstrAtom(VtlParser.SubstrAtomContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            ResolvableExpression expr = ctx.expr() == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr());
            ResolvableExpression start = ctx.startParameter == null ? ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.startParameter);
            ResolvableExpression len = ctx.endParameter == null ? ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.endParameter);
            List<ResolvableExpression> parameters = List.of(expr, start, len);
            return this.genericFunctionsVisitor.invokeFunction("substr", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitReplaceAtom(VtlParser.ReplaceAtomContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            ResolvableExpression expr = ctx.expr(0) == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr(0));
            ResolvableExpression param = ctx.param == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.param);
            ResolvableExpression optionalExpr = ctx.optionalExpr() == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.optionalExpr());
            List<ResolvableExpression> parameters = List.of(expr, param, optionalExpr);
            return this.genericFunctionsVisitor.invokeFunction("replace", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }

    public ResolvableExpression visitInstrAtom(VtlParser.InstrAtomContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            ResolvableExpression expr = ctx.expr(0) == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.expr(0));
            ResolvableExpression pattern = ctx.pattern == null ? ResolvableExpression.withType(String.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.pattern);
            ResolvableExpression start = ctx.startParameter == null ? ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.startParameter);
            ResolvableExpression occurence = ctx.occurrenceParameter == null ? ResolvableExpression.withType(Long.class).withPosition(pos).using((VtlFunction & Serializable)c -> null) : (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.occurrenceParameter);
            List<ResolvableExpression> parameters = List.of(expr, pattern, start, occurence);
            return this.genericFunctionsVisitor.invokeFunction("instr", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

