/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression.functions;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.UndefinedVariableException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.utils.TypeChecking;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.DataPointRuleset;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.HierarchicalRuleset;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class ValidationFunctionsVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor expressionVisitor;
    private final ProcessingEngine processingEngine;
    private final VtlScriptEngine engine;

    public ValidationFunctionsVisitor(ExpressionVisitor expressionVisitor, ProcessingEngine processingEngine, VtlScriptEngine engine) {
        this.expressionVisitor = Objects.requireNonNull(expressionVisitor);
        this.processingEngine = Objects.requireNonNull(processingEngine);
        this.engine = Objects.requireNonNull(engine);
    }

    public ResolvableExpression visitValidateDPruleset(VtlParser.ValidateDPrulesetContext ctx) {
        String dprName = ctx.dpName.getText();
        Object dprObject = this.engine.getContext().getAttribute(dprName);
        String output = this.getValidationOutput(ctx.validationOutput());
        if (!(dprObject instanceof DataPointRuleset)) {
            throw new VtlRuntimeException(new UndefinedVariableException(dprName, VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        DataPointRuleset dpr = (DataPointRuleset)dprObject;
        DatasetExpression ds = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.op), Dataset.class, (ParseTree)ctx.op);
        Structured.DataStructure dataStructure = ds.getDataStructure();
        dpr.getVariables().forEach(v -> {
            if (!dataStructure.containsKey(v)) {
                throw new VtlRuntimeException(new InvalidArgumentException("Variable " + v + " not contained in " + ctx.op.getText(), VtlScriptEngine.fromContext((ParseTree)ctx)));
            }
        });
        dpr.getAlias().values().forEach(v -> {
            if (dataStructure.containsKey(v)) {
                throw new VtlRuntimeException(new InvalidArgumentException("Alias " + v + " from " + dprName + " ruleset already defined in " + ctx.op.getText(), VtlScriptEngine.fromContext((ParseTree)ctx)));
            }
        });
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        return this.processingEngine.executeValidateDPruleset(dpr, ds, output, pos);
    }

    public ResolvableExpression visitValidationSimple(VtlParser.ValidationSimpleContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        DatasetExpression dsExpression = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.expr()), Dataset.class, (ParseTree)ctx.expr());
        List exprMeasures = dsExpression.getDataStructure().values().stream().filter(Structured.Component::isMeasure).collect(Collectors.toList());
        if (exprMeasures.size() != 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Check operand dataset contains several measures", pos));
        }
        if (((Structured.Component)exprMeasures.get(0)).getType() != Boolean.class) {
            throw new VtlRuntimeException(new InvalidArgumentException("Check operand dataset measure has to be boolean", pos));
        }
        ResolvableExpression erCodeExpression = null != ctx.erCode() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.erCode()) : null;
        ResolvableExpression erLevelExpression = null != ctx.erLevel() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.erLevel()) : null;
        DatasetExpression imbalanceExpression = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.imbalanceExpr()), Dataset.class, (ParseTree)ctx.imbalanceExpr());
        if (null != imbalanceExpression) {
            List imbalanceMeasures = imbalanceExpression.getDataStructure().values().stream().filter(Structured.Component::isMeasure).collect(Collectors.toList());
            if (imbalanceMeasures.size() != 1) {
                throw new VtlRuntimeException(new InvalidArgumentException("Check imbalance dataset contains several measures", pos));
            }
            ArrayList<Class> supportedClasses = new ArrayList<Class>(Arrays.asList(Double.class, Long.class));
            if (!supportedClasses.contains(((Structured.Component)imbalanceMeasures.get(0)).getType())) {
                throw new VtlRuntimeException(new InvalidArgumentException("Check imbalance dataset measure has to be numeric", pos));
            }
        }
        String output = ctx.output != null ? ctx.output.getText() : null;
        return this.processingEngine.executeValidationSimple(dsExpression, erCodeExpression, erLevelExpression, imbalanceExpression, output, pos);
    }

    public ResolvableExpression visitValidateHRruleset(VtlParser.ValidateHRrulesetContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        DatasetExpression dsExpression = (DatasetExpression)TypeChecking.assertTypeExpression((ResolvableExpression)this.expressionVisitor.visit((ParseTree)ctx.expr()), Dataset.class, (ParseTree)ctx.expr());
        String datasetName = ctx.expr().getText();
        String hrName = ctx.hrName.getText();
        Object hrObject = this.engine.getContext().getAttribute(hrName);
        if (!(hrObject instanceof HierarchicalRuleset)) {
            throw new VtlRuntimeException(new UndefinedVariableException(hrName, pos));
        }
        HierarchicalRuleset hr = (HierarchicalRuleset)hrObject;
        Structured.DataStructure dataStructure = dsExpression.getDataStructure();
        List measures = dataStructure.getMeasures();
        if (measures.size() != 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Dataset " + datasetName + " is not monomeasure", VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        ArrayList<Class> supportedClasses = new ArrayList<Class>(Arrays.asList(Double.class, Long.class));
        if (!supportedClasses.contains(((Structured.Component)measures.get(0)).getType())) {
            throw new VtlRuntimeException(new InvalidArgumentException("Dataset " + datasetName + " measure " + ((Structured.Component)measures.get(0)).getName() + " has to have number type", VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        String componentID = ctx.componentID().getText();
        if (!dataStructure.containsKey((Object)componentID)) {
            throw new VtlRuntimeException(new InvalidArgumentException("ComponentID " + componentID + " not contained in dataset " + datasetName, VtlScriptEngine.fromContext((ParseTree)ctx)));
        }
        String validationMode = this.getValidationMode(ctx.validationMode());
        String inputMode = this.getInputMode(ctx.inputMode());
        String validationOutput = this.getValidationOutput(ctx.validationOutput());
        return this.processingEngine.executeHierarchicalValidation(dsExpression, hr, componentID, validationMode, inputMode, validationOutput, pos);
    }

    private String getValidationOutput(VtlParser.ValidationOutputContext voc) {
        if (null == voc) {
            return null;
        }
        return voc.getText();
    }

    private String getValidationMode(VtlParser.ValidationModeContext vmc) {
        if (null == vmc) {
            return null;
        }
        return vmc.getText();
    }

    private String getInputMode(VtlParser.InputModeContext imc) {
        if (null == imc) {
            return null;
        }
        return imc.getText();
    }
}

