/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.threeten.extra.Interval;
import org.threeten.extra.PeriodDuration;

public class TemporalFunctions {
    public static Instant addition(Instant op, PeriodDuration dur) {
        return op.plus((TemporalAmount)dur);
    }

    public static Instant addition(PeriodDuration dur, Instant op) {
        return op.plus((TemporalAmount)dur);
    }

    public static ZonedDateTime addition(ZonedDateTime op, PeriodDuration dur) {
        return op.plus((TemporalAmount)dur);
    }

    public static ZonedDateTime addition(PeriodDuration dur, ZonedDateTime op) {
        return op.plus((TemporalAmount)dur);
    }

    public static OffsetDateTime addition(OffsetDateTime op, PeriodDuration dur) {
        return op.plus((TemporalAmount)dur);
    }

    public static OffsetDateTime addition(PeriodDuration dur, OffsetDateTime op) {
        return op.plus((TemporalAmount)dur);
    }

    public static Instant subtraction(Instant op, PeriodDuration amount) {
        return op.minus((TemporalAmount)amount);
    }

    public static ZonedDateTime subtraction(ZonedDateTime op, PeriodDuration amount) {
        return op.minus((TemporalAmount)amount);
    }

    public static OffsetDateTime subtraction(OffsetDateTime op, PeriodDuration amount) {
        return op.minus((TemporalAmount)amount);
    }

    public static Instant subtraction(PeriodDuration amount, Instant op) {
        return op.minus((TemporalAmount)amount);
    }

    public static ZonedDateTime subtraction(PeriodDuration amount, ZonedDateTime op) {
        return op.minus((TemporalAmount)amount);
    }

    public static OffsetDateTime subtraction(PeriodDuration amount, OffsetDateTime op) {
        return op.minus((TemporalAmount)amount);
    }

    public static PeriodDuration subtraction(Instant a, Instant b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(Instant a, OffsetDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(Instant a, ZonedDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(OffsetDateTime a, Instant b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(OffsetDateTime a, OffsetDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(OffsetDateTime a, ZonedDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(ZonedDateTime a, Instant b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(ZonedDateTime a, OffsetDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration subtraction(ZonedDateTime a, ZonedDateTime b) {
        return PeriodDuration.between((Temporal)b, (Temporal)a);
    }

    public static PeriodDuration multiplication(PeriodDuration a, Long b) {
        return a.multipliedBy(Math.toIntExact(b));
    }

    public static PeriodDuration multiplication(Long b, PeriodDuration a) {
        return TemporalFunctions.multiplication(a, b);
    }

    public static PeriodDuration period_indicator(Interval timePeriod) {
        return PeriodDuration.between((Temporal)timePeriod.getStart(), (Temporal)timePeriod.getEnd());
    }

    public static Interval timeshift(Interval time, Long n) {
        OffsetDateTime from = time.getStart().atOffset(ZoneOffset.UTC);
        OffsetDateTime to = time.getEnd().atOffset(ZoneOffset.UTC);
        PeriodDuration dur = PeriodDuration.between((Temporal)from, (Temporal)to).multipliedBy(n.intValue());
        return Interval.of((Instant)from.plus(dur.getPeriod()).toInstant(), (Instant)to.plus(dur.getPeriod()).toInstant());
    }

    public static ZonedDateTime at_zone(Instant op, String zone) {
        ZoneId zid = ZoneId.of(zone);
        return op.atZone(zid);
    }

    private static Interval truncate_time(Interval op, ChronoUnit unit, ZoneId zone) {
        Instant start = TemporalFunctions.truncate_time(op.getStart(), unit, zone);
        return Interval.of((Instant)start, (Duration)unit.getDuration());
    }

    public static Interval truncate_time(Interval op, String unit, String zone) {
        return TemporalFunctions.truncate_time(op, TemporalFunctions.toChronoUnit(unit), ZoneId.of(zone));
    }

    public static Interval truncate_time(Interval op, String unit) {
        return TemporalFunctions.truncate_time(op, TemporalFunctions.toChronoUnit(unit), ZoneId.systemDefault());
    }

    private static Instant truncate_time(Instant op, ChronoUnit unit, ZoneId zone) {
        ZonedDateTime zonedOp = op.atZone(zone);
        switch (unit) {
            case DAYS: {
                return zonedOp.truncatedTo(ChronoUnit.DAYS).toInstant();
            }
            case MONTHS: {
                return zonedOp.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).toInstant();
            }
            case YEARS: {
                return zonedOp.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS).toInstant();
            }
            case HOURS: {
                return zonedOp.truncatedTo(ChronoUnit.HOURS).toInstant();
            }
            case MINUTES: {
                return zonedOp.truncatedTo(ChronoUnit.MINUTES).toInstant();
            }
            case SECONDS: {
                return zonedOp.truncatedTo(ChronoUnit.SECONDS).toInstant();
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + unit);
    }

    public static Instant truncate_time(Instant op, String unit, String zone) {
        return TemporalFunctions.truncate_time(op, TemporalFunctions.toChronoUnit(unit), ZoneId.of(zone));
    }

    public static Instant truncate_time(Instant op, String unit) {
        return TemporalFunctions.truncate_time(op, TemporalFunctions.toChronoUnit(unit), (ZoneId)ZoneOffset.UTC);
    }

    public static ZonedDateTime truncate_time(ZonedDateTime op, String unit) {
        ZoneId zone = op.getZone();
        return TemporalFunctions.truncate_time(op.toInstant(), TemporalFunctions.toChronoUnit(unit), zone).atZone(zone);
    }

    public static OffsetDateTime truncate_time(OffsetDateTime op, String unit) {
        ZonedDateTime zoned = op.toZonedDateTime();
        return TemporalFunctions.truncate_time(zoned.toInstant(), TemporalFunctions.toChronoUnit(unit), zoned.getZone()).atOffset(op.getOffset());
    }

    private static ChronoUnit toChronoUnit(String unit) {
        switch (unit.toLowerCase()) {
            case "day": {
                return ChronoUnit.DAYS;
            }
            case "month": {
                return ChronoUnit.MONTHS;
            }
            case "year": {
                return ChronoUnit.YEARS;
            }
            case "hour": {
                return ChronoUnit.HOURS;
            }
            case "minute": {
                return ChronoUnit.MINUTES;
            }
            case "second": {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + unit);
    }
}

