/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine;

import fr.insee.vtl.engine.VtlNativeMethods;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.exceptions.VtlSyntaxException;
import fr.insee.vtl.engine.visitors.AssignmentVisitor;
import fr.insee.vtl.model.FunctionProvider;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ProcessingEngineFactory;
import fr.insee.vtl.model.VtlMethod;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlLexer;
import fr.insee.vtl.parser.VtlParser;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class VtlScriptEngine
extends AbstractScriptEngine {
    public static final String PROCESSING_ENGINE_NAMES = "$vtl.engine.processing_engine_names";
    private final ScriptEngineFactory factory;
    private Map<String, Method> methodCache;
    private Map<String, Method> globalMethodCache;

    public VtlScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public static Positioned fromToken(Token token) {
        Positioned.Position position = new Positioned.Position(Integer.valueOf(token.getLine() - 1), Integer.valueOf(token.getLine() - 1), Integer.valueOf(token.getCharPositionInLine()), Integer.valueOf(token.getCharPositionInLine() + (token.getStopIndex() - token.getStartIndex() + 1)));
        return () -> position;
    }

    public static Positioned fromContext(ParseTree tree) {
        if (tree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)tree;
            return VtlScriptEngine.fromTokens(parserRuleContext.getStart(), parserRuleContext.getStop());
        }
        if (tree instanceof TerminalNode) {
            return VtlScriptEngine.fromToken(((TerminalNode)tree).getSymbol());
        }
        throw new IllegalStateException();
    }

    public static Positioned fromTokens(Token from, Token to) {
        if (to == null) {
            to = from;
        }
        Positioned.Position position = new Positioned.Position(Integer.valueOf(from.getLine() - 1), Integer.valueOf(to.getLine() - 1), Integer.valueOf(from.getCharPositionInLine()), Integer.valueOf(to.getCharPositionInLine() + (to.getStopIndex() - to.getStartIndex() + 1)));
        return () -> position;
    }

    static boolean matchParameters(Method method, Class<?> ... classes) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (classes.length != parameterTypes.length) {
            return false;
        }
        HashMap typeArguments = new HashMap();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (VtlScriptEngine.isAssignableTo(classes[i], parameterTypes[i], genericParameterTypes[i], typeArguments)) continue;
            return false;
        }
        return true;
    }

    static boolean isAssignableTo(Class<?> clazz, Class<?> target, Type genericTarget, Map<TypeVariable<?>, Class<?>> typeArguments) {
        if (target.isAssignableFrom(clazz)) {
            if (genericTarget instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)genericTarget;
                Class<?> existingTypeArgument = typeArguments.get(typeVariable);
                if (existingTypeArgument == null) {
                    typeArguments.put(typeVariable, clazz);
                } else {
                    return existingTypeArgument.equals(clazz);
                }
            }
            return true;
        }
        if (genericTarget instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericTarget;
            Type[] typeArgumentsArray = parameterizedType.getActualTypeArguments();
            if (typeArgumentsArray.length != 1) {
                return false;
            }
            Type typeArgument = typeArgumentsArray[0];
            if (typeArgument instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)typeArgument;
                Class<?> existingTypeArgument = typeArguments.get(typeVariable);
                if (existingTypeArgument != null) {
                    return existingTypeArgument.equals(clazz);
                }
                typeArguments.put(typeVariable, clazz);
                return true;
            }
            if (typeArgument instanceof Class) {
                Class classArgument = (Class)typeArgument;
                return classArgument.isAssignableFrom(clazz);
            }
        }
        return false;
    }

    private String getProcessingEngineName() {
        Object engineName = Optional.ofNullable(this.get(PROCESSING_ENGINE_NAMES)).orElse("memory");
        if (engineName instanceof String) {
            return (String)engineName;
        }
        throw new IllegalArgumentException("$vtl.engine.processing_engine_names must be a string");
    }

    public ProcessingEngine getProcessingEngine() {
        String name = this.getProcessingEngineName();
        Optional<ProcessingEngineFactory> factory = Java8Helpers.streamIterator(ServiceLoader.load(ProcessingEngineFactory.class).iterator()).filter(f -> f.getName().equals(name)).findFirst();
        return factory.orElseThrow(() -> new NoSuchElementException("No value present")).getProcessingEngine((ScriptEngine)this);
    }

    private Object evalStream(CodePointCharStream stream, ScriptContext context) throws VtlScriptException {
        try {
            VtlLexer lexer = new VtlLexer((CharStream)stream);
            final ArrayDeque errors = new ArrayDeque();
            BaseErrorListener baseErrorListener = new BaseErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int startLine, int startColumn, String msg, RecognitionException e) {
                    if (e != null && e.getCtx() != null) {
                        errors.add(new VtlScriptException(msg, VtlScriptEngine.fromContext((ParseTree)e.getCtx())));
                    } else if (offendingSymbol instanceof Token) {
                        errors.add(new VtlSyntaxException(msg, VtlScriptEngine.fromToken((Token)offendingSymbol)));
                    } else {
                        Positioned.Position pos = new Positioned.Position(Integer.valueOf(startLine), Integer.valueOf(startLine), Integer.valueOf(startColumn), Integer.valueOf(startColumn + 1));
                        errors.add(new VtlScriptException(msg, () -> pos));
                    }
                }
            };
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)baseErrorListener);
            VtlParser parser = new VtlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)baseErrorListener);
            VtlParser.StartContext start = parser.start();
            if (!errors.isEmpty()) {
                VtlScriptException first = (VtlScriptException)((Object)errors.removeFirst());
                for (VtlScriptException suppressed : errors) {
                    first.addSuppressed((Throwable)suppressed);
                }
                throw first;
            }
            AssignmentVisitor assignmentVisitor = new AssignmentVisitor(this, this.getProcessingEngine());
            Object lastValue = null;
            for (VtlParser.StatementContext stmt : start.statement()) {
                lastValue = assignmentVisitor.visit((ParseTree)stmt);
            }
            return lastValue;
        }
        catch (VtlRuntimeException vre) {
            throw vre.getCause();
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws VtlScriptException {
        CodePointCharStream stream = CharStreams.fromString((String)script);
        return this.evalStream(stream, context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            CodePointCharStream stream = CharStreams.fromReader((Reader)reader);
            return this.evalStream(stream, context);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public VtlMethod findMethod(String name, Collection<Class> types) throws NoSuchMethodException {
        Set<Method> customMethods = this.methodCache == null ? Java8Helpers.setOf((Object[])new Method[0]) : new HashSet<Method>(this.methodCache.values());
        Set methods = Stream.concat(VtlNativeMethods.NATIVE_METHODS.stream(), customMethods.stream()).collect(Collectors.toSet());
        List candidates = methods.stream().filter(method -> method.getName().equals(name)).filter(method -> VtlScriptEngine.matchParameters(method, types.toArray(new Class[0]))).collect(Collectors.toList());
        if (candidates.size() == 1) {
            return new VtlMethod((Method)candidates.get(0));
        }
        for (Method method2 : methods) {
            if (!method2.getName().equals(name) || !types.equals(Arrays.asList(method2.getParameterTypes()))) continue;
            return new VtlMethod(method2);
        }
        throw new NoSuchMethodException(this.methodToString(name, types));
    }

    public VtlMethod findGlobalMethod(String name, Collection<Class> types) throws NoSuchMethodException {
        if (this.globalMethodCache == null) {
            return null;
        }
        HashSet<Method> methods = new HashSet<Method>(this.globalMethodCache.values());
        List candidates = methods.stream().filter(method -> method.getName().equals(name)).filter(method -> VtlScriptEngine.matchParameters(method, types.toArray(new Class[0]))).collect(Collectors.toList());
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return new VtlMethod((Method)candidates.get(0));
        }
        for (Method method2 : methods) {
            if (!method2.getName().equals(name) || !types.equals(Arrays.asList(method2.getParameterTypes()))) continue;
            return new VtlMethod(method2);
        }
        throw new NoSuchMethodException(this.methodToString(name, types));
    }

    private String methodToString(String name, Collection<Class> argTypes) {
        StringJoiner sj = new StringJoiner(", ", name + "(", ")");
        if (argTypes != null) {
            for (Class c : argTypes) {
                sj.add(c == null ? "null" : c.getSimpleName());
            }
        }
        return sj.toString();
    }

    public Method registerMethod(String name, Method method) {
        if (this.methodCache == null) {
            this.loadMethods();
        }
        return this.methodCache.put(name, method);
    }

    public Method registerGlobalMethod(String name, Method method) {
        if (this.globalMethodCache == null) {
            this.globalMethodCache = new LinkedHashMap<String, Method>();
        }
        return this.globalMethodCache.put(name, method);
    }

    private void loadMethods() {
        this.methodCache = new LinkedHashMap<String, Method>();
        ServiceLoader<FunctionProvider> providers = ServiceLoader.load(FunctionProvider.class);
        for (FunctionProvider provider : providers) {
            Map functions = provider.getFunctions((ScriptEngine)this);
            for (String name : functions.keySet()) {
                this.methodCache.put(name, (Method)functions.get(name));
            }
        }
    }
}

