/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.utils;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.TypedExpression;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.InvalidTypeException;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

public class TypeChecking {
    private TypeChecking() {
        throw new IllegalStateException("Type checking utility class");
    }

    public static <T extends TypedExpression> T assertTypeExpression(T expression, Class<?> type, ParseTree tree) {
        if (TypeChecking.isNull(expression)) {
            Positioned pos = VtlScriptEngine.fromContext(tree);
            return (T)ResolvableExpression.withType(type).withPosition(pos).using((VtlFunction & Serializable)c -> null);
        }
        if (!TypeChecking.isType(expression, type)) {
            throw new VtlRuntimeException((VtlScriptException)new InvalidTypeException(type, expression.getType(), VtlScriptEngine.fromContext(tree)));
        }
        return expression;
    }

    public static boolean isType(TypedExpression expression, Class<?> type) {
        return type.isAssignableFrom(expression.getType());
    }

    public static <T extends TypedExpression> T assertNumberOrTypeExpression(T expression, Class<?> type, ParseTree tree) {
        if (!TypeChecking.isNumberOrSameType(expression, type)) {
            throw new VtlRuntimeException((VtlScriptException)new InvalidTypeException(type, expression.getType(), VtlScriptEngine.fromContext(tree)));
        }
        return expression;
    }

    public static boolean isNumberOrSameType(TypedExpression expression, Class<?> type) {
        Class expressionType = expression.getType();
        if (TypeChecking.isNumber(expression) && Number.class.isAssignableFrom(type)) {
            return true;
        }
        return type.isAssignableFrom(expressionType);
    }

    public static boolean hasSameTypeOrNull(List<ResolvableExpression> expressions) {
        return expressions.stream().map(TypedExpression::getType).filter(clazz -> !Object.class.equals(clazz)).distinct().count() <= 1L;
    }

    public static boolean isNull(TypedExpression expression) {
        return Object.class.equals((Object)expression.getType());
    }

    public static boolean isNumber(TypedExpression expression) {
        return TypeChecking.isType(expression, Number.class);
    }

    public static <T extends TypedExpression> T assertNumber(T expression, ParseTree tree) {
        return TypeChecking.assertTypeExpression(expression, Number.class, tree);
    }

    public static boolean isLong(TypedExpression expression) {
        return TypeChecking.isType(expression, Long.class);
    }

    public static <T extends TypedExpression> T assertLong(T expression, ParseTree tree) {
        return TypeChecking.assertTypeExpression(expression, Long.class, tree);
    }

    public static boolean isDouble(TypedExpression expression) {
        return TypeChecking.isType(expression, Double.class);
    }

    public static <T extends TypedExpression> T assertDouble(T expression, ParseTree tree) {
        return TypeChecking.assertTypeExpression(expression, Double.class, tree);
    }

    public static boolean isBoolean(TypedExpression expression) {
        return TypeChecking.isType(expression, Boolean.class);
    }

    public static <T extends TypedExpression> T assertBoolean(T expression, ParseTree tree) {
        return TypeChecking.assertTypeExpression(expression, Boolean.class, tree);
    }

    public static boolean isString(TypedExpression expression) {
        return TypeChecking.isType(expression, String.class);
    }

    public static <T extends TypedExpression> T assertString(T expression, ParseTree tree) {
        return TypeChecking.assertTypeExpression(expression, String.class, tree);
    }

    public static boolean hasNullArgs(Object ... objects) {
        return Stream.of(objects).anyMatch(Objects::isNull);
    }
}

