/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.utils.safetymirror.util;

import fr.insee.vtl.engine.utils.safetymirror.Fun;
import fr.insee.vtl.engine.utils.safetymirror.util.SignatureUtil;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SerializedLambdaToMethod {
    private SerializedLambdaToMethod() {
    }

    public static Method createMethodFromSuperConsumer(Fun lambda) {
        SerializedLambda serializedLambda = SerializedLambdaToMethod.getSerializedLambda(lambda);
        return SerializedLambdaToMethod.getMethod(serializedLambda);
    }

    private static Method getMethod(SerializedLambda serializedLambda) {
        if (serializedLambda == null) {
            return null;
        }
        String className = SignatureUtil.compactClassName(serializedLambda.getImplClass(), false);
        try {
            return Class.forName(className).getDeclaredMethod(serializedLambda.getImplMethodName(), SerializedLambdaToMethod.getParameters(serializedLambda.getImplMethodSignature()));
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static SerializedLambda getSerializedLambda(Fun lambda) {
        SerializedLambda serializedLambda = null;
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (!(replacement instanceof SerializedLambda)) break;
                serializedLambda = (SerializedLambda)replacement;
                break;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return serializedLambda;
    }

    public static String createMethodNameFromSuperConsumer(Fun lambda) {
        SerializedLambda serializedLambda = SerializedLambdaToMethod.getSerializedLambda(lambda);
        return serializedLambda.getImplMethodName();
    }

    private static Class<?>[] getParameters(String signature) throws ClassNotFoundException {
        String[] parameters = signature.substring(1, signature.lastIndexOf(41)).replaceAll("/", ".").split(";");
        String[] params = SignatureUtil.methodSignatureArgumentTypes(signature, false);
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = SerializedLambdaToMethod.isPrimitive(params[i]) ? SerializedLambdaToMethod.getPrimitiveClass(params[i]) : Class.forName(params[i].contains("[") ? parameters[i] + ";" : params[i]);
        }
        return paramTypes;
    }

    private static boolean isPrimitive(String param) {
        switch (param) {
            case "byte": {
                return true;
            }
            case "short": {
                return true;
            }
            case "int": {
                return true;
            }
            case "long": {
                return true;
            }
            case "double": {
                return true;
            }
            case "float": {
                return true;
            }
            case "boolean": {
                return true;
            }
            case "char": {
                return true;
            }
        }
        return false;
    }

    private static Class<?> getPrimitiveClass(String param) {
        switch (param) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        throw new UnsupportedOperationException("Unmapped switch case. Have a new primitive data type been added to the Java language?");
    }
}

