/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.utils.safetymirror.util;

import java.util.ArrayList;

public class SignatureUtil {
    private static ThreadLocal<Integer> consumed_chars = new ThreadLocal(){

        protected Integer initialValue() {
            return 0;
        }
    };

    private static int unwrap(ThreadLocal<Integer> tl) {
        return tl.get();
    }

    private static void wrap(ThreadLocal<Integer> tl, int value) {
        tl.set(value);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws RuntimeException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new RuntimeException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(SignatureUtil.signatureToString(signature.substring(index), chopit));
                index += SignatureUtil.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("Invalid method signature: " + signature);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static final String signatureToString(String signature, boolean chopit) {
        SignatureUtil.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new RuntimeException("Invalid signature: " + signature);
                    }
                    SignatureUtil.wrap(consumed_chars, index + 1);
                    return SignatureUtil.compactClassName(signature.substring(1, index), chopit);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumed_chars = n;
                    String type = SignatureUtil.signatureToString(signature.substring(n), chopit);
                    int _temp = SignatureUtil.unwrap(SignatureUtil.consumed_chars) + consumed_chars;
                    SignatureUtil.wrap(SignatureUtil.consumed_chars, _temp);
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new RuntimeException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("Invalid signature: " + e + ":" + signature);
        }
    }

    public static final String compactClassName(String str) {
        return SignatureUtil.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return SignatureUtil.compactClassName(str, "java.lang.", chopit);
    }
}

