/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.ClauseVisitor;
import fr.insee.vtl.model.Analytics;
import fr.insee.vtl.model.DatasetExpression;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class AnalyticsVisitor
extends VtlBaseVisitor<DatasetExpression> {
    private final ProcessingEngine processingEngine;
    private final DatasetExpression dataset;
    private final String targetColumnName;

    public AnalyticsVisitor(ProcessingEngine processingEngine, DatasetExpression dataset, String targetColumnName) {
        this.processingEngine = processingEngine;
        this.dataset = dataset;
        this.targetColumnName = targetColumnName;
    }

    private Analytics.Function toFunctionEnum(Token op, ParseTree ctx) {
        switch (op.getType()) {
            case 99: {
                return Analytics.Function.SUM;
            }
            case 100: {
                return Analytics.Function.AVG;
            }
            case 102: {
                return Analytics.Function.COUNT;
            }
            case 101: {
                return Analytics.Function.MEDIAN;
            }
            case 80: {
                return Analytics.Function.MIN;
            }
            case 81: {
                return Analytics.Function.MAX;
            }
            case 141: {
                return Analytics.Function.STDDEV_POP;
            }
            case 142: {
                return Analytics.Function.STDDEV_SAMP;
            }
            case 143: {
                return Analytics.Function.VAR_POP;
            }
            case 144: {
                return Analytics.Function.VAR_SAMP;
            }
            case 148: {
                return Analytics.Function.FIRST_VALUE;
            }
            case 149: {
                return Analytics.Function.LAST_VALUE;
            }
            case 151: {
                return Analytics.Function.LEAD;
            }
            case 150: {
                return Analytics.Function.LAG;
            }
            case 152: {
                return Analytics.Function.RATIO_TO_REPORT;
            }
            case 77: {
                return Analytics.Function.RANK;
            }
        }
        throw new VtlRuntimeException(new InvalidArgumentException("not an analytic function", VtlScriptEngine.fromContext(ctx)));
    }

    private List<String> toPartitionBy(VtlParser.PartitionByClauseContext partition) {
        if (partition == null) {
            return Java8Helpers.listOf((Object[])new String[0]);
        }
        return partition.componentID().stream().map(ClauseVisitor::getName).collect(Collectors.toList());
    }

    private Map<String, Analytics.Order> toOrderBy(VtlParser.OrderByClauseContext orderByCtx) {
        if (orderByCtx == null) {
            return Java8Helpers.mapOf();
        }
        LinkedHashMap<String, Analytics.Order> orderBy = new LinkedHashMap<String, Analytics.Order>();
        for (VtlParser.OrderByItemContext item : orderByCtx.orderByItem()) {
            String columnName = ClauseVisitor.getName(item.componentID());
            if (item.DESC() != null) {
                orderBy.put(columnName, Analytics.Order.DESC);
                continue;
            }
            orderBy.put(columnName, Analytics.Order.ASC);
        }
        return orderBy;
    }

    private Analytics.WindowSpec toWindowSpec(VtlParser.WindowingClauseContext windowing) {
        if (windowing == null) {
            return null;
        }
        Long from = this.toRangeLong(windowing.from_);
        Long to = this.toRangeLong(windowing.to_);
        if (windowing.RANGE() != null) {
            return new Analytics.RangeWindow(from, to);
        }
        return new Analytics.DataPointWindow(from, to);
    }

    private Long toRangeLong(VtlParser.LimitClauseItemContext ctx) {
        if (ctx.CURRENT() != null) {
            return 0L;
        }
        if (ctx.UNBOUNDED() != null && ctx.PRECEDING() != null) {
            return Long.MIN_VALUE;
        }
        if (ctx.UNBOUNDED() != null && ctx.FOLLOWING() != null) {
            return Long.MAX_VALUE;
        }
        if (ctx.INTEGER_CONSTANT() != null) {
            return Long.parseLong(ctx.getChild(0).getText());
        }
        throw new VtlRuntimeException(new VtlScriptException("invalid range", VtlScriptEngine.fromContext((ParseTree)ctx)));
    }

    private String toTargetColName(VtlParser.ExprContext expr) {
        return expr.getText();
    }

    private int toOffset(VtlParser.SignedIntegerContext offet) {
        return Integer.parseInt(offet.getText());
    }

    public DatasetExpression visitAnSimpleFunction(VtlParser.AnSimpleFunctionContext ctx) {
        return this.processingEngine.executeSimpleAnalytic(this.dataset, this.targetColumnName, this.toFunctionEnum(ctx.op, (ParseTree)ctx), this.toTargetColName(ctx.expr()), this.toPartitionBy(ctx.partition), this.toOrderBy(ctx.orderBy), this.toWindowSpec(ctx.windowing));
    }

    public DatasetExpression visitLagOrLeadAn(VtlParser.LagOrLeadAnContext ctx) {
        return this.processingEngine.executeLeadOrLagAn(this.dataset, this.targetColumnName, this.toFunctionEnum(ctx.op, (ParseTree)ctx), this.toTargetColName(ctx.expr()), this.toOffset(ctx.offset), this.toPartitionBy(ctx.partition), this.toOrderBy(ctx.orderBy));
    }

    public DatasetExpression visitRatioToReportAn(VtlParser.RatioToReportAnContext ctx) {
        return this.processingEngine.executeRatioToReportAn(this.dataset, this.targetColumnName, this.toFunctionEnum(ctx.op, (ParseTree)ctx), this.toTargetColName(ctx.expr()), this.toPartitionBy(ctx.partition));
    }

    public DatasetExpression visitRankAn(VtlParser.RankAnContext ctx) {
        return this.processingEngine.executeRankAn(this.dataset, this.targetColumnName, this.toFunctionEnum(ctx.op, (ParseTree)ctx), this.toPartitionBy(ctx.partition), this.toOrderBy(ctx.orderBy));
    }
}

