/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.InvalidArgumentException;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.model.DataPointRule;
import fr.insee.vtl.model.DataPointRuleset;
import fr.insee.vtl.model.Dataset;
import fr.insee.vtl.model.HierarchicalRule;
import fr.insee.vtl.model.HierarchicalRuleset;
import fr.insee.vtl.model.PersistentDataset;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ProcessingEngine;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.Structured;
import fr.insee.vtl.model.VtlFunction;
import fr.insee.vtl.model.exceptions.InvalidTypeException;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AssignmentVisitor
extends VtlBaseVisitor<Object> {
    private final VtlScriptEngine engine;
    private final ProcessingEngine processingEngine;
    private final ExpressionVisitor expressionVisitor;

    public AssignmentVisitor(VtlScriptEngine engine, ProcessingEngine processingEngine) {
        this.engine = Objects.requireNonNull(engine);
        this.processingEngine = Objects.requireNonNull(processingEngine);
        this.expressionVisitor = new ExpressionVisitor(engine.getBindings(100), processingEngine, engine);
    }

    private Object visitAssignment(VtlParser.ExprContext expr) {
        ResolvableExpression resolvableExpression = (ResolvableExpression)this.expressionVisitor.visit((ParseTree)expr);
        return resolvableExpression.resolve((Map)this.engine.getBindings(100));
    }

    public Object visitTemporaryAssignment(VtlParser.TemporaryAssignmentContext ctx) {
        Object result = this.visitAssignment(ctx.expr());
        Bindings bindings = this.engine.getBindings(100);
        String variableIdentifier = ctx.varID().getText();
        bindings.put(variableIdentifier, result);
        return result;
    }

    public Object visitPersistAssignment(VtlParser.PersistAssignmentContext ctx) {
        Object result = this.visitAssignment(ctx.expr());
        if (result instanceof Dataset) {
            result = new PersistentDataset((Dataset)result);
            Bindings bindings = this.engine.getBindings(100);
            String variableIdentifier = ctx.varID().getText();
            bindings.put(variableIdentifier, result);
            return result;
        }
        throw new VtlRuntimeException((VtlScriptException)new InvalidTypeException(Dataset.class, result.getClass(), VtlScriptEngine.fromContext((ParseTree)ctx)));
    }

    public Object visitDefDatapointRuleset(VtlParser.DefDatapointRulesetContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        String rulesetName = ctx.rulesetID().getText();
        List signature = ctx.rulesetSignature().signature();
        List variables = ctx.rulesetSignature().VARIABLE() != null ? signature.stream().map(s -> s.varID().getText()).collect(Collectors.toList()) : Java8Helpers.listOf((Object[])new String[0]);
        List valuedomains = ctx.rulesetSignature().VALUE_DOMAIN() != null ? signature.stream().map(s -> s.varID().getText()).collect(Collectors.toList()) : Java8Helpers.listOf((Object[])new String[0]);
        Map<String, String> alias = signature.stream().filter(s -> null != s.alias()).collect(Collectors.toMap(k -> k.varID().getText(), v -> v.alias().getText()));
        Set erCodeTypes = ctx.ruleClauseDatapoint().ruleItemDatapoint().stream().map(c -> {
            VtlParser.ErCodeContext erCodeContext = c.erCode();
            if (null == erCodeContext) {
                return Object.class;
            }
            return ((ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erCode())).getType();
        }).collect(Collectors.toSet());
        List filteredErCodeTypes = erCodeTypes.stream().filter(t -> !t.equals(Object.class)).collect(Collectors.toList());
        if (filteredErCodeTypes.size() > 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Error codes of rules have different types", pos));
        }
        Class erCodeType = filteredErCodeTypes.isEmpty() ? String.class : (Class)filteredErCodeTypes.iterator().next();
        Set erLevelTypes = ctx.ruleClauseDatapoint().ruleItemDatapoint().stream().map(c -> {
            VtlParser.ErLevelContext erLevelContext = c.erLevel();
            if (null == erLevelContext) {
                return Object.class;
            }
            return ((ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erLevel())).getType();
        }).collect(Collectors.toSet());
        List filteredErLevelTypes = erLevelTypes.stream().filter(t -> !t.equals(Object.class)).collect(Collectors.toList());
        if (filteredErLevelTypes.size() > 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Error levels of rules have different types", pos));
        }
        Class erLevelType = filteredErLevelTypes.isEmpty() ? Long.class : (Class)filteredErLevelTypes.iterator().next();
        AtomicInteger index = new AtomicInteger();
        List rules = ctx.ruleClauseDatapoint().ruleItemDatapoint().stream().map(c -> {
            TerminalNode identifier = c.IDENTIFIER();
            int i = index.getAndIncrement() + 1;
            String name = null != identifier ? identifier.getText() : rulesetName + "_" + i;
            VtlParser.ExprContext antecedentContiditonContext = c.antecedentContiditon;
            VtlParser.ExprContext consequentConditionContext = c.consequentCondition;
            ResolvableExpression errorCodeExpression = null != c.erCode() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erCode()) : null;
            ResolvableExpression errorLevelExpression = null != c.erLevel() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erLevel()) : null;
            return new DataPointRule(name, dataStructure -> {
                if (antecedentContiditonContext != null) {
                    Map<String, Object> componentMap = dataStructure.values().stream().collect(Collectors.toMap(Structured.Component::getName, component -> component));
                    return (ResolvableExpression)new ExpressionVisitor(componentMap, this.processingEngine, this.engine).visit((ParseTree)antecedentContiditonContext);
                }
                return ResolvableExpression.withType(Boolean.class).withPosition(pos).using((VtlFunction & Serializable)cc -> Boolean.TRUE);
            }, dataStructure -> {
                Map<String, Object> componentMap = dataStructure.values().stream().collect(Collectors.toMap(Structured.Component::getName, component -> component));
                return (ResolvableExpression)new ExpressionVisitor(componentMap, this.processingEngine, this.engine).visit((ParseTree)consequentConditionContext);
            }, errorCodeExpression, errorLevelExpression);
        }).collect(Collectors.toList());
        DataPointRuleset dataPointRuleset = new DataPointRuleset(rulesetName, rules, variables, valuedomains, alias, erCodeType, erLevelType);
        Bindings bindings = this.engine.getBindings(100);
        bindings.put(rulesetName, (Object)dataPointRuleset);
        return dataPointRuleset;
    }

    public Object visitDefHierarchical(VtlParser.DefHierarchicalContext ctx) {
        Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
        String rulesetName = ctx.rulesetID().getText();
        String variable = ctx.hierRuleSignature().IDENTIFIER().getText();
        Set erCodeTypes = ctx.ruleClauseHierarchical().ruleItemHierarchical().stream().map(c -> {
            VtlParser.ErCodeContext erCodeContext = c.erCode();
            if (null == erCodeContext) {
                return Object.class;
            }
            return ((ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erCode())).getType();
        }).collect(Collectors.toSet());
        List filteredErCodeTypes = erCodeTypes.stream().filter(t -> !t.equals(Object.class)).collect(Collectors.toList());
        if (filteredErCodeTypes.size() > 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Error codes of rules have different types", pos));
        }
        Class erCodeType = filteredErCodeTypes.isEmpty() ? String.class : (Class)filteredErCodeTypes.iterator().next();
        Set erLevelTypes = ctx.ruleClauseHierarchical().ruleItemHierarchical().stream().map(c -> {
            VtlParser.ErLevelContext erLevelContext = c.erLevel();
            if (null == erLevelContext) {
                return Object.class;
            }
            return ((ResolvableExpression)this.expressionVisitor.visit((ParseTree)c.erLevel())).getType();
        }).collect(Collectors.toSet());
        List filteredErLevelTypes = erLevelTypes.stream().filter(t -> !t.equals(Object.class)).collect(Collectors.toList());
        if (filteredErLevelTypes.size() > 1) {
            throw new VtlRuntimeException(new InvalidArgumentException("Error levels of rules have different types", pos));
        }
        Class erLevelType = filteredErLevelTypes.isEmpty() ? Long.class : (Class)filteredErLevelTypes.iterator().next();
        AtomicInteger index = new AtomicInteger();
        List rules = ctx.ruleClauseHierarchical().ruleItemHierarchical().stream().map(r -> {
            TerminalNode identifier = r.IDENTIFIER();
            int i = index.getAndIncrement() + 1;
            String ruleName = null != identifier ? identifier.getText() : rulesetName + "_" + i;
            ArrayList<String> codeItems = new ArrayList<String>();
            VtlParser.CodeItemRelationContext codeItemRelationContext = r.codeItemRelation();
            String valueDomainValue = codeItemRelationContext.valueDomainValue().IDENTIFIER().getText();
            codeItems.add(valueDomainValue);
            VtlParser.ComparisonOperandContext comparisonOperandContext = codeItemRelationContext.comparisonOperand();
            StringBuilder codeItemExpressionBuilder = new StringBuilder();
            codeItemRelationContext.codeItemRelationClause().forEach(circ -> {
                TerminalNode minus = circ.MINUS();
                String rightCodeItem = circ.rightCodeItem.getText();
                codeItems.add(rightCodeItem);
                if (minus != null) {
                    codeItemExpressionBuilder.append(" -").append(rightCodeItem);
                }
                codeItemExpressionBuilder.append(" +").append(rightCodeItem);
            });
            String rightExpressionToEval = codeItemExpressionBuilder.toString();
            String expressionToEval = "bool_var := " + valueDomainValue + " " + comparisonOperandContext.getText() + " " + rightExpressionToEval + ";";
            ResolvableExpression leftExpression = ResolvableExpression.withType(Double.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                SimpleBindings bindings = new SimpleBindings((Map<String, Object>)context);
                bindings.forEach((k, v) -> this.engine.getContext().setAttribute((String)k, v, 100));
                try {
                    this.engine.eval("left := " + valueDomainValue + ";");
                    Object left = this.engine.getContext().getAttribute("left");
                    this.engine.getContext().removeAttribute("left", 100);
                    bindings.keySet().forEach(k -> this.engine.getContext().removeAttribute((String)k, 100));
                    if (left.getClass().isAssignableFrom(Double.class)) {
                        return (Double)left;
                    }
                    return ((Long)left).doubleValue();
                }
                catch (ScriptException e) {
                    throw new VtlRuntimeException(new VtlScriptException("right hierarchical rule has to return long or double", pos));
                }
            });
            ResolvableExpression rightExpression = ResolvableExpression.withType(Double.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                SimpleBindings bindings = new SimpleBindings((Map<String, Object>)context);
                bindings.forEach((k, v) -> this.engine.getContext().setAttribute((String)k, v, 100));
                try {
                    this.engine.eval("right := " + rightExpressionToEval + ";");
                    Object right = this.engine.getContext().getAttribute("right");
                    this.engine.getContext().removeAttribute("right", 100);
                    bindings.keySet().forEach(k -> this.engine.getContext().removeAttribute((String)k, 100));
                    if (right.getClass().isAssignableFrom(Double.class)) {
                        return (Double)right;
                    }
                    return ((Long)right).doubleValue();
                }
                catch (ScriptException e) {
                    throw new VtlRuntimeException(new VtlScriptException("right hierarchical rule has to return long or double", pos));
                }
            });
            ResolvableExpression expression = ResolvableExpression.withType(Boolean.class).withPosition(pos).using((VtlFunction & Serializable)context -> {
                SimpleBindings bindings = new SimpleBindings((Map<String, Object>)context);
                bindings.forEach((k, v) -> this.engine.getContext().setAttribute((String)k, v, 100));
                try {
                    this.engine.eval(expressionToEval);
                    Boolean boolVar = (Boolean)this.engine.getContext().getAttribute("bool_var");
                    this.engine.getContext().removeAttribute("bool_var", 100);
                    bindings.keySet().forEach(k -> this.engine.getContext().removeAttribute((String)k, 100));
                    return boolVar;
                }
                catch (ScriptException e) {
                    throw new VtlRuntimeException(new VtlScriptException("hierarchical rule has to return boolean", pos));
                }
            });
            ResolvableExpression errorCodeExpression = null != r.erCode() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)r.erCode()) : null;
            ResolvableExpression errorLevelExpression = null != r.erLevel() ? (ResolvableExpression)this.expressionVisitor.visit((ParseTree)r.erLevel()) : null;
            return new HierarchicalRule(ruleName, valueDomainValue, expression, leftExpression, rightExpression, codeItems, errorCodeExpression, errorLevelExpression);
        }).collect(Collectors.toList());
        HierarchicalRuleset hr = new HierarchicalRuleset(rules, variable, erCodeType, erLevelType);
        Bindings bindings = this.engine.getBindings(100);
        bindings.put(rulesetName, (Object)hr);
        return hr;
    }
}

