/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.Positioned;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class ArithmeticExprOrConcatVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public ArithmeticExprOrConcatVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Long addition(Long valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA + valueB;
    }

    public static Double addition(Long valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return (double)valueA.longValue() + valueB;
    }

    public static Double addition(Double valueA, Long valueB) {
        return ArithmeticExprOrConcatVisitor.addition(valueB, valueA);
    }

    public static Double addition(Double valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA + valueB;
    }

    public static Long subtraction(Long valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA - valueB;
    }

    public static Double subtraction(Long valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return (double)valueA.longValue() - valueB;
    }

    public static Double subtraction(Double valueA, Long valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA - valueB.doubleValue();
    }

    public static Double subtraction(Double valueA, Double valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA - valueB;
    }

    public static String concat(String valueA, String valueB) {
        if (valueA == null || valueB == null) {
            return null;
        }
        return valueA + valueB;
    }

    public ResolvableExpression visitArithmeticExprOrConcat(VtlParser.ArithmeticExprOrConcatContext ctx) {
        try {
            Positioned pos = VtlScriptEngine.fromContext((ParseTree)ctx);
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right)});
            switch (ctx.op.getType()) {
                case 13: {
                    return this.genericFunctionsVisitor.invokeFunction("addition", parameters, pos);
                }
                case 14: {
                    return this.genericFunctionsVisitor.invokeFunction("subtraction", parameters, pos);
                }
                case 94: {
                    return this.genericFunctionsVisitor.invokeFunction("concat", parameters, pos);
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

