/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.vtl.engine.visitors.expression;

import fr.insee.vtl.engine.VtlScriptEngine;
import fr.insee.vtl.engine.exceptions.VtlRuntimeException;
import fr.insee.vtl.engine.visitors.expression.ExpressionVisitor;
import fr.insee.vtl.engine.visitors.expression.functions.GenericFunctionsVisitor;
import fr.insee.vtl.model.ResolvableExpression;
import fr.insee.vtl.model.exceptions.VtlScriptException;
import fr.insee.vtl.model.utils.Java8Helpers;
import fr.insee.vtl.parser.VtlBaseVisitor;
import fr.insee.vtl.parser.VtlParser;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class BooleanVisitor
extends VtlBaseVisitor<ResolvableExpression> {
    private final ExpressionVisitor exprVisitor;
    private final GenericFunctionsVisitor genericFunctionsVisitor;

    public BooleanVisitor(ExpressionVisitor expressionVisitor, GenericFunctionsVisitor genericFunctionsVisitor) {
        this.exprVisitor = Objects.requireNonNull(expressionVisitor);
        this.genericFunctionsVisitor = Objects.requireNonNull(genericFunctionsVisitor);
    }

    public static Boolean and(Boolean left, Boolean right) {
        if (left != null && !left.booleanValue()) {
            return false;
        }
        if (right != null && !right.booleanValue()) {
            return false;
        }
        if (left == null || right == null) {
            return null;
        }
        return true;
    }

    public static Boolean or(Boolean left, Boolean right) {
        if (left != null && left.booleanValue()) {
            return true;
        }
        if (right != null && right.booleanValue()) {
            return true;
        }
        if (left == null || right == null) {
            return null;
        }
        return false;
    }

    public static Boolean xor(Boolean left, Boolean right) {
        if (left == null || right == null) {
            return null;
        }
        return left ^ right;
    }

    public ResolvableExpression visitBooleanExpr(VtlParser.BooleanExprContext ctx) {
        try {
            List parameters = Java8Helpers.listOf((Object[])new ResolvableExpression[]{(ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.left), (ResolvableExpression)this.exprVisitor.visit((ParseTree)ctx.right)});
            switch (ctx.op.getType()) {
                case 47: {
                    return this.genericFunctionsVisitor.invokeFunction("and", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 48: {
                    return this.genericFunctionsVisitor.invokeFunction("or", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
                case 49: {
                    return this.genericFunctionsVisitor.invokeFunction("xor", parameters, VtlScriptEngine.fromContext((ParseTree)ctx));
                }
            }
            throw new UnsupportedOperationException("unknown operator " + ctx);
        }
        catch (VtlScriptException e) {
            throw new VtlRuntimeException(e);
        }
    }
}

